/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.task;

import java.io.DataOutputStream;
import java.io.IOException;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.util.stream.OutputStreamLimiter;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class SendBitfield
implements ThreadTask {
    TorrentPeer peer;

    public SendBitfield(TorrentPeer peer) {
        this.peer = peer;
    }

    @Override
    public boolean execute() throws Exception {
        DataOutputStream os = new DataOutputStream(new OutputStreamLimiter(this.peer.getSocket().getOutputStream(), this.peer.getPeersManager().getTorrent().getUploadBandwidthLimiter()));
        byte[] bitField = this.peer.getPeersManager().getTorrent().getTorrentDisk().getBitfieldCopy();
        os.writeInt(1 + bitField.length);
        os.writeByte(5);
        os.write(bitField);
        return false;
    }

    @Override
    public void interrupt() {
        try {
            this.peer.getSocket().close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void exceptionCought(Exception e) {
        e.printStackTrace();
        this.peer.interrupt();
    }
}

