/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.bitlet.wetorrent.Event;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.peer.message.Have;
import org.bitlet.wetorrent.peer.message.Message;
import org.bitlet.wetorrent.util.Utils;

public class PeersManager {
    private List<Peer> connectingPeers = new LinkedList<Peer>();
    private List<Peer> activePeers = new LinkedList<Peer>();
    private int connectionCreationTreshold = 35;
    private int maxConnection = 45;
    private Torrent torrent;
    private long disconnectedClientDownloaded = 0L;
    private long disconnectedClientUploaded = 0L;

    public PeersManager(Torrent torrent) {
        this.torrent = torrent;
    }

    public synchronized TorrentPeer offer(byte[] peerId, InetAddress ip, int port) {
        for (Peer peer : this.connectingPeers) {
            if (peer.getPort() != port || !peer.getIp().equals(ip)) continue;
            return null;
        }
        for (Peer peer : this.activePeers) {
            if (peer.getPort() != port || !peer.getIp().equals(ip)) continue;
            return null;
        }
        if (this.activePeers.size() < this.connectionCreationTreshold) {
            TorrentPeer peer = new TorrentPeer(peerId, ip, port, this);
            peer.start();
            this.connectingPeers.add(peer);
            return peer;
        }
        return null;
    }

    public synchronized TorrentPeer offer(TorrentPeer peer) {
        if (this.activePeers.size() > this.maxConnection) {
            peer.interrupt();
            return null;
        }
        peer.setPeersManager(this);
        this.connectingPeers.add(peer);
        return peer;
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public synchronized long getUploaded() {
        long uploaded = this.disconnectedClientUploaded;
        for (Peer p : this.activePeers) {
            uploaded += p.getUploaded();
        }
        return uploaded;
    }

    public synchronized void interrupted(Peer peer) {
        this.connectingPeers.remove(peer);
        if (this.activePeers.remove(peer)) {
            this.torrent.interrupted(peer);
            this.disconnectedClientDownloaded += peer.getDownloaded();
            this.disconnectedClientUploaded += peer.getUploaded();
        }
    }

    public synchronized int[] getPiecesFrequencies() {
        int[] frequencies = new int[this.torrent.getMetafile().getPieces().size()];
        for (int i = 0; i < frequencies.length; ++i) {
            for (Peer p : this.activePeers) {
                if (!p.hasPiece(i)) continue;
                int n = i;
                frequencies[n] = frequencies[n] + 1;
            }
        }
        return frequencies;
    }

    public synchronized long getDownloaded() {
        long downloaded = this.disconnectedClientDownloaded;
        for (Peer p : this.activePeers) {
            downloaded += p.getDownloaded();
        }
        return downloaded;
    }

    public synchronized void tick() {
        long now = System.currentTimeMillis();
        LinkedList<Peer> peersTimedOut = new LinkedList<Peer>();
        for (Peer p : this.activePeers) {
            if (now - p.getLastReceivedMessageMillis() > 120000L) {
                peersTimedOut.add(p);
                continue;
            }
            if (now - p.getLastReceivedMessageMillis() <= 110000L) continue;
            p.sendMessage(new Message(-1, null));
        }
        for (Peer p : peersTimedOut) {
            p.interrupt();
            this.interrupted(p);
        }
    }

    public synchronized void interrupt() {
        while (this.connectingPeers.size() > 0) {
            this.connectingPeers.get(0).interrupt();
        }
        while (this.activePeers.size() > 0) {
            this.activePeers.get(0).interrupt();
        }
    }

    public synchronized void sendHave(Have have) {
        for (Peer p : this.activePeers) {
            if (p.hasPiece(have.getIndex())) continue;
            p.sendMessage(have);
        }
    }

    public synchronized int getActivePeersNumber() {
        return this.activePeers.size();
    }

    public synchronized int getSeedersNumber() {
        int acc = 0;
        for (Peer peer : this.activePeers) {
            acc += peer.isSeeder() ? 1 : 0;
        }
        return acc;
    }

    public synchronized void connected(Peer peer) {
        if (!this.connectingPeers.remove(peer)) {
            // empty if block
        }
        for (Peer p : this.activePeers) {
            if (!Utils.bytesCompare(peer.getPeerId(), p.getPeerId())) continue;
            peer.interrupt();
            this.torrent.addEvent(new Event(this, "Peer already connected", Level.FINE));
            return;
        }
        this.activePeers.add(peer);
    }
}

