/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.model.storages;

import java.io.InputStream;
import java.util.Map;
import org.gcube.common.storagehub.model.exceptions.StorageIdNotFoundException;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.MetaInfo;

public abstract class StorageBackend {
    private PayloadBackend payloadConfiguration;

    public StorageBackend(PayloadBackend payloadConfiguration) {
        this.payloadConfiguration = payloadConfiguration;
    }

    public PayloadBackend getPayloadConfiguration() {
        return this.payloadConfiguration;
    }

    protected void setPayloadConfiguration(PayloadBackend payloadConfiguration) {
        this.payloadConfiguration = payloadConfiguration;
    }

    public abstract MetaInfo onCopy(Content var1, String var2, String var3);

    public abstract MetaInfo onMove(Content var1, String var2);

    public abstract void delete(String var1);

    public abstract MetaInfo upload(InputStream var1, String var2, String var3, String var4);

    public abstract MetaInfo upload(InputStream var1, String var2, String var3, Long var4, String var5);

    public abstract InputStream download(Content var1) throws StorageIdNotFoundException;

    public abstract InputStream download(String var1) throws StorageIdNotFoundException;

    public abstract Map<String, String> getFileMetadata(String var1);

    public abstract MetaInfo upload(InputStream var1, String var2, String var3, String var4, Long var5, String var6);

    @Deprecated
    public abstract String getTotalSizeStored();

    @Deprecated
    public abstract String getTotalItemsCount();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.payloadConfiguration == null ? 0 : this.payloadConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageBackend other = (StorageBackend)obj;
        return !(this.payloadConfiguration == null ? other.payloadConfiguration != null : !this.payloadConfiguration.equals(other.payloadConfiguration));
    }
}

