/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.model;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.model.SoftwareArtifactFile;
import org.gcube.common.software.model.Variables;
import org.gcube.common.software.utils.Utils;

public class SoftwareArtifactConfig {
    public static final String PREVIOUS_CONCEPT_DOI_VALUE = "PREVIOUS";
    public static final String NAME_PROPERTY_NAME = "name";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final String TITLE_PROPERTY_NAME = "title";
    public static final String DATE_PROPERTY_NAME = "date";
    public static final String LICENSE_PROPERTY_NAME = "license";
    public static final String KEYWORDS_PROPERTY_NAME = "keywords";
    public static final String DESCRIPTION_PROPERTY_NAME = "description";
    public static final String AUTHORS_PROPERTY_NAME = "authors";
    public static final String FILES_PROPERTY_NAME = "files";
    public static final String CODE_LOCATION_PROPERTY_NAME = "code_location";
    public static final String CONCEPT_DOI_URL_PROPERTY_NAME = "concept_doi_url";
    public static final String VERSION_DOI_URL_PROPERTY_NAME = "version_doi_url";
    public static final String GRANTS_PROPERTY_NAME = "grants";
    @JsonIgnore
    protected SoftwareArtifactConfig previous;
    @JsonIgnore
    protected SoftwareArtifactConfig next;
    @JsonIgnore
    protected Boolean newDeposition = false;
    @JsonIgnore
    protected ObjectNode originalJson;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="version")
    protected String version;
    @JsonProperty(value="date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    protected Date date;
    @JsonProperty(value="title")
    protected String title;
    @JsonProperty(value="license")
    protected JsonNode license;
    @JsonProperty(value="keywords")
    protected Set<String> keywords;
    @JsonProperty(value="authors")
    protected ArrayNode authors;
    @JsonProperty(value="files")
    protected List<SoftwareArtifactFile> files;
    @JsonProperty(value="code_location")
    protected String codeLocation;
    @JsonProperty(value="concept_doi_url")
    protected String conceptDOIURL;
    @JsonProperty(value="version_doi_url")
    protected String versionDOIURL;
    @JsonProperty(value="grants")
    protected JsonNode grants;
    protected Map<String, JsonNode> additionalProperties = new LinkedHashMap<String, JsonNode>();

    @JsonIgnore
    public SoftwareArtifactConfig getPrevious() {
        return this.previous;
    }

    @JsonIgnore
    public void setPrevious(SoftwareArtifactConfig previous) {
        this.previous = previous;
        if (previous != null) {
            this.previous.next = this;
        }
    }

    @JsonIgnore
    public SoftwareArtifactConfig getNext() {
        return this.next;
    }

    @JsonIgnore
    public Boolean isNewDeposition() {
        return this.newDeposition;
    }

    @JsonIgnore
    public void setNewDeposition(Boolean newVersion) {
        this.newDeposition = newVersion;
    }

    @JsonIgnore
    public Variables getVariables() throws Exception {
        JsonNode jsonNode;
        ObjectMapper objectMapper = Utils.getObjectMapper();
        Variables variables = (Variables)objectMapper.treeToValue((TreeNode)(jsonNode = objectMapper.valueToTree((Object)this)), Variables.class);
        Set<String> missingVariables = variables.parse();
        int size = missingVariables.size();
        if (size > 0) {
            throw new Exception("The following variables has been used but not defined or cannot be actualised" + missingVariables.toArray(new String[size]).toString());
        }
        return variables;
    }

    @JsonIgnore
    public ObjectNode getOriginalJson() {
        return this.originalJson;
    }

    @JsonIgnore
    public void setOriginalJson(ObjectNode originalJson) {
        this.originalJson = originalJson;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getTitle() {
        return this.title;
    }

    public JsonNode getLicense() {
        return this.license;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public ArrayNode getAuthors() {
        return this.authors;
    }

    public List<SoftwareArtifactFile> getFiles() {
        return this.files;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public String getConceptDOIURL() {
        if (this.conceptDOIURL != null && this.conceptDOIURL.compareTo(PREVIOUS_CONCEPT_DOI_VALUE) == 0) {
            if (this.previous != null) {
                this.conceptDOIURL = this.previous.getConceptDOIURL();
            } else {
                throw new RuntimeException("concept_doi_url is indicates as PREVIOUS but " + this.getTitle() + " has no previous. Please check you config.");
            }
        }
        return this.conceptDOIURL;
    }

    public void setConceptDOIURL(String conceptDOIURL) {
        this.conceptDOIURL = conceptDOIURL;
    }

    public String getVersionDOIURL() {
        return this.versionDOIURL;
    }

    public void setVersionDOIURL(String versionDOIURL) {
        this.versionDOIURL = versionDOIURL;
    }

    public JsonNode getGrants() {
        return this.grants;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void addAdditionalProperty(String key, JsonNode value) {
        this.additionalProperties.put(key, value);
    }

    @JsonIgnore
    public JsonNode getAdditionalProperty(String key) {
        return this.additionalProperties.get(key);
    }
}

