/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.analyser;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.export.SoftwareArtifactProcessor;
import org.gcube.common.software.model.ExporterConfig;
import org.gcube.common.software.model.GlobalConfig;
import org.gcube.common.software.model.SoftwareArtifactConfig;
import org.gcube.common.software.model.SoftwareArtifactFile;
import org.gcube.common.software.model.Variables;
import org.gcube.common.software.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyser {
    private static final Logger logger = LoggerFactory.getLogger(Analyser.class);
    protected ObjectMapper objectMapper = Utils.getObjectMapper();
    protected File outputDirectory;
    protected ObjectNode globalConfiguration;
    protected ArrayNode versionConfigurations;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public ObjectNode getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(ObjectNode originalGlobal) {
        this.globalConfiguration = originalGlobal.deepCopy();
    }

    public ArrayNode getVersionConfigurations() {
        return this.versionConfigurations;
    }

    public void setVersionConfigurations(ArrayNode originalVersions) {
        this.versionConfigurations = originalVersions.deepCopy();
    }

    protected SoftwareArtifactConfig actualizeSoftwareVersionConfig(JsonNode version) throws Exception {
        ((ObjectNode)version).remove("exporters");
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)version, Variables.class);
        Set<String> missingVariables = variables.parse();
        int size = missingVariables.size();
        if (size > 0) {
            throw new Exception("The following variables has been used but not defined or cannot be actualised" + missingVariables.toArray(new String[size]).toString());
        }
        JsonNode swVersion = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        SoftwareArtifactConfig softwareVersionConfig = (SoftwareArtifactConfig)this.objectMapper.treeToValue((TreeNode)swVersion, SoftwareArtifactConfig.class);
        List<SoftwareArtifactFile> svfs = softwareVersionConfig.getFiles();
        for (SoftwareArtifactFile svf : svfs) {
            URL url = svf.getURL();
            String urlString = variables.replaceAllVariables(url.toString());
            svf.setURL(new URL(urlString));
            String desiredName = svf.getDesiredName();
            desiredName = variables.replaceAllVariables(desiredName);
            svf.setDesiredName(desiredName);
        }
        return softwareVersionConfig;
    }

    protected GlobalConfig getGlobalConfig(JsonNode node) throws Exception {
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)node, Variables.class);
        variables.parse();
        JsonNode sc = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        GlobalConfig globalConfig = (GlobalConfig)this.objectMapper.treeToValue((TreeNode)sc, GlobalConfig.class);
        globalConfig.setOriginalJson(this.globalConfiguration);
        return globalConfig;
    }

    protected ExporterConfig actualizeExporterConfig(ExporterConfig exporterConfig, SoftwareArtifactConfig softwareVersionConfig) throws Exception {
        ObjectNode versionNode = (ObjectNode)this.objectMapper.valueToTree((Object)softwareVersionConfig);
        Variables versionVariables = (Variables)this.objectMapper.treeToValue((TreeNode)versionNode, Variables.class);
        ObjectNode node = (ObjectNode)this.objectMapper.valueToTree((Object)exporterConfig);
        Variables variables = (Variables)this.objectMapper.treeToValue((TreeNode)node, Variables.class);
        variables.parseWith(versionVariables);
        JsonNode ec = (JsonNode)this.objectMapper.convertValue(variables.getProperties(), JsonNode.class);
        return (ExporterConfig)this.objectMapper.treeToValue((TreeNode)ec, ExporterConfig.class);
    }

    protected void checkExporters(Set<String> availableExporterNames, Set<String> requestedExporterNames) throws Exception {
        if (!availableExporterNames.containsAll(requestedExporterNames)) {
            requestedExporterNames.removeAll(availableExporterNames);
            throw new Exception("The following requested exporters does not exists " + requestedExporterNames);
        }
    }

    public List<File> analyse() throws Exception {
        GlobalConfig globalConfig = this.getGlobalConfig((JsonNode)this.globalConfiguration);
        Map<String, Class<? extends SoftwareArtifactProcessor>> availableExporters = SoftwareArtifactProcessor.getAvailableExporters();
        Map<String, ExporterConfig> requestedExporters = globalConfig.getExporters();
        this.checkExporters(availableExporters.keySet(), requestedExporters.keySet());
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(globalConfig.getFileName());
        }
        if (!this.outputDirectory.exists()) {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        SoftwareArtifactConfig previous = null;
        int i = 0;
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (i = 0; i < this.versionConfigurations.size(); ++i) {
            ObjectNode versionConfig = (ObjectNode)this.versionConfigurations.get(i).deepCopy();
            JsonNode mergedVersionConfig = Utils.merge((JsonNode)this.globalConfiguration, (JsonNode)versionConfig);
            SoftwareArtifactConfig softwareVersionConfig = this.actualizeSoftwareVersionConfig(mergedVersionConfig);
            softwareVersionConfig.setOriginalJson(versionConfig);
            softwareVersionConfig.setPrevious(previous);
            logger.trace("Going to process {}", (Object)softwareVersionConfig.getTitle());
            for (String className : requestedExporters.keySet()) {
                logger.debug("Going to export with {}", (Object)className);
                Class<? extends SoftwareArtifactProcessor> exporterClass = availableExporters.get(className);
                ExporterConfig exporterConfig = requestedExporters.get(className);
                exporterConfig = this.actualizeExporterConfig(exporterConfig, softwareVersionConfig);
                SoftwareArtifactProcessor sve = exporterClass.newInstance();
                sve.setOutputDirectory(this.outputDirectory);
                sve.setGlobalConfig(globalConfig);
                sve.setSoftwareVersionConfig(softwareVersionConfig);
                sve.setExporterConfig(exporterConfig);
                sve.setFirst(i == 0);
                boolean last = i == this.versionConfigurations.size() - 1;
                sve.setLast(last);
                sve.export();
                if (!last) continue;
                outputFiles.add(sve.getOutputFile());
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
            previous = softwareVersionConfig;
        }
        return outputFiles;
    }
}

