package org.gcube.common.software.export;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.gcube.common.software.export.biblatex.BibLaTeXExporter;
import org.gcube.common.software.export.zenodo.ZenodoExporter;
import org.gcube.common.software.model.ExporterConfig;
import org.gcube.common.software.model.GlobalConfig;
import org.gcube.common.software.model.SoftwareArtifactConfig;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class SoftwareArtifactProcessor {

	protected static Map<String, Class<? extends SoftwareArtifactProcessor>> availableProcessors;
	
	static {
		availableProcessors = new HashMap<>();
		add(ZenodoExporter.class);
		add(BibLaTeXExporter.class);
	}
	
	private static void add(Class<? extends SoftwareArtifactProcessor> clz) {
		availableProcessors.put(clz.getSimpleName(), clz);
	}
	
	public static Map<String, Class<? extends SoftwareArtifactProcessor>> getAvailableExporters() {
		return availableProcessors;
	}
	
	protected File outputDirectory;
	protected GlobalConfig globalConfig;
	protected SoftwareArtifactConfig softwareVersionConfig;
	protected ExporterConfig exporterConfig;
	
	protected boolean first;
	protected boolean last;
	
	protected final String exportFileNameExtension; 
	
	protected SoftwareArtifactProcessor(String exportFileNameExtension) {
		this.exportFileNameExtension = exportFileNameExtension;
	}
	
	public void setOutputDirectory(File outputDirectory) {
		this.outputDirectory = outputDirectory;
	}

	public GlobalConfig getGlobalConfig() {
		return globalConfig;
	}

	public void setGlobalConfig(GlobalConfig globalConfig) {
		this.globalConfig = globalConfig;
	}

	public SoftwareArtifactConfig getSoftwareVersionConfig() {
		return softwareVersionConfig;
	}

	public void setSoftwareVersionConfig(SoftwareArtifactConfig softwareVersionConfig) {
		this.softwareVersionConfig = softwareVersionConfig;
	}
	
	public ExporterConfig getExporterConfig() {
		return exporterConfig;
	}
	
	public void setExporterConfig(ExporterConfig processorConfig) {
		this.exporterConfig = processorConfig;
	}

	public void setFirst(boolean first) {
		this.first = first;
	}
	
	public void setLast(boolean last) {
		this.last = last;
	}

	public abstract void export() throws Exception;
	
	public File getOutputFile() throws Exception {
		String fileName = globalConfig.getFileName()+exportFileNameExtension;
		File file = new File(outputDirectory, fileName);
		return file;
	}
	
}
