/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.model.ExporterConfig;

public class GlobalConfig {
    public static final String EXPORT_FILENAME_PROPERTY_NAME = "export_filename";
    public static final String EXPORTERS_PROPERTY_NAME = "exporters";
    @JsonProperty(value="exporters")
    protected Map<String, ExporterConfig> exporters;
    protected Map<String, JsonNode> properties = new LinkedHashMap<String, JsonNode>();
    @JsonIgnore
    protected ObjectNode originalJson;

    public Map<String, ExporterConfig> getExporters() {
        return this.exporters;
    }

    @JsonIgnore
    public ObjectNode getOriginalJson() {
        return this.originalJson;
    }

    @JsonIgnore
    public void setOriginalJson(ObjectNode originalJson) {
        this.originalJson = originalJson;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void addProperty(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    @JsonIgnore
    public JsonNode getProperty(String key) {
        return this.properties.get(key);
    }

    protected String getExportFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            return simpleDateFormat.format(Calendar.getInstance().getTime());
        }
        return fileName;
    }

    public String getFileName() {
        JsonNode jsonNode = this.getProperty(EXPORT_FILENAME_PROPERTY_NAME);
        String fileName = jsonNode.getNodeType() == JsonNodeType.NULL ? null : jsonNode.asText();
        fileName = this.getExportFileName(fileName);
        return fileName;
    }
}

