package org.gcube.common.software.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.SerializationFeature;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class Utils {
	
	/**
	 * DateTime Pattern to be used to serialize Dates
	 */
	public static final String DATETIME_PATTERN = "yyyy-MM-dd";

	public static String getDateAsString(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
		return simpleDateFormat.format(date);
	}
	
	protected static ObjectMapper objectMapper;
	
	static {
		objectMapper = new ObjectMapper();
		SimpleDateFormat sdf = new SimpleDateFormat(Utils.DATETIME_PATTERN);
		objectMapper.setDateFormat(sdf);
		objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
	}
	
	public static ObjectMapper getObjectMapper() {
		return objectMapper;
	}
	
	public static String replaceVariable(String variableName, String replace, String s) {
		return s.replaceAll("\\{\\{" + variableName + "\\}\\}", replace);
	}
	
	/*
	 * Merge all the properties contained in version in concept 
	 */
	public static JsonNode merge(JsonNode node1, JsonNode node2) {
		ObjectNode cloned = node1.deepCopy();
		Iterator<String> iterator = node2.fieldNames();
		while (iterator.hasNext()) {
			String fieldName = iterator.next();
			JsonNode value = node2.get(fieldName);
			cloned.replace(fieldName, value.deepCopy());
		}
		return cloned;
	}
}
