/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.common.software.utils.Utils;

public class Variables {
    public static final String REGEX = "\\{\\{[a-zA-Z\\-\\_]+\\}\\}";
    public static final Pattern PATTERN = Pattern.compile(REGEX);
    protected Map<String, Object> properties = new LinkedHashMap<String, Object>();

    protected Set<String> findVariables(String value) {
        HashSet<String> variables = new HashSet<String>();
        Matcher m = PATTERN.matcher(value);
        if (m.find()) {
            do {
                String variable = m.group();
                variable = variable.replaceAll("\\{", "");
                variable = variable.replaceAll("\\}", "");
                variables.add(variable);
            } while (m.find(m.start() + 1));
        }
        return variables;
    }

    public String replaceAllVariables(String value) throws Exception {
        HashSet<String> missingVariables = new HashSet<String>();
        Set<String> variableNames = this.findVariables(value);
        for (String variableName : variableNames) {
            if (this.properties.containsKey(variableName)) {
                try {
                    String variableValue = this.properties.get(variableName).toString();
                    value = Utils.replaceVariable(variableName, variableValue, value);
                }
                catch (Exception e) {
                    missingVariables.add(variableName);
                }
                continue;
            }
            missingVariables.add(variableName);
        }
        if (missingVariables.size() > 0) {
            throw new Exception("The following variables cannot be replaced because they don't exists " + ((Object)missingVariables).toString());
        }
        return value;
    }

    protected Set<String> replaceAllVariables(String key, String value) throws Exception {
        HashSet<String> missingVariables = new HashSet<String>();
        Set<String> variableNames = this.findVariables(value);
        for (String variableName : variableNames) {
            if (variableName.compareTo(key) == 0) {
                throw new Exception("You can't define self as variable in the value");
            }
            if (this.properties.containsKey(variableName)) {
                String variableValue = this.properties.get(variableName).toString();
                value = Utils.replaceVariable(variableName, variableValue, value);
                continue;
            }
            missingVariables.add(variableName);
        }
        this.properties.replace(key, value);
        return missingVariables;
    }

    protected Set<String> parseAndReplace() throws Exception {
        HashSet<String> missingVariables = new HashSet<String>();
        Set<String> keys = this.properties.keySet();
        for (String key : keys) {
            Object objectValue = this.properties.get(key);
            if (!(objectValue instanceof String)) continue;
            String value = (String)objectValue;
            missingVariables.addAll(this.replaceAllVariables(key, value));
        }
        return missingVariables;
    }

    public Set<String> parse() throws Exception {
        Set<String> missingVariables = this.parseAndReplace();
        while (missingVariables.size() > 0) {
            Set<String> newMissingVariables = this.parseAndReplace();
            if (newMissingVariables.containsAll(missingVariables)) {
                return missingVariables;
            }
            missingVariables = newMissingVariables;
        }
        return missingVariables;
    }

    public Set<String> parseWith(Variables variables) throws Exception {
        for (String property : this.properties.keySet()) {
            variables.addProperty(property, this.properties.get(property));
        }
        Set<String> missingVariables = variables.parse();
        for (String property : this.properties.keySet()) {
            this.properties.put(property, variables.getProperties().get(property));
        }
        return missingVariables;
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonIgnore
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonAnySetter
    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

