package org.gcube.common.security.secrets;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.security.Owner;

public class UmaTokenSecret extends Secret {

	private static final String AUTH_HEADER = "Authorization";
	private static final String USER_HEADER = "d4s-user";

	private String encodedUmaToken;

	private Owner owner;
	private String context;

	private AccessToken accessToken;

	private boolean initialised = false;

	public UmaTokenSecret(String encodedUmaToken) {
		this.encodedUmaToken = encodedUmaToken;
	}

	@Override
	public Owner getOwner() {
		init();
		return this.owner;
	}

	@Override
	public String getContext() {
		init();
		return this.context;
	}

	@Override
	public Map<String, String> getHTTPAuthorizationHeaders() {
		Map<String, String> authorizationHeaders = new HashMap<>();
		authorizationHeaders.put(AUTH_HEADER, "Bearer " + this.encodedUmaToken);
		String encodedUser = Base64.getEncoder().encodeToString(this.getOwner().getId().getBytes());
		authorizationHeaders.put(USER_HEADER, encodedUser);
		return authorizationHeaders;

	}

	protected String getEncodedUmaToken() {
		return encodedUmaToken;
	}


	@Override
	public boolean isExpired() {
		init();
		return accessToken.isExpired();
	}

	private synchronized void init() {
		if (!initialised)
			try {

				String realAccessTokenEncoded = encodedUmaToken.split("\\.")[1];

				String decodedAccessPart = new String(Base64.getDecoder().decode(realAccessTokenEncoded.getBytes()));

				ObjectMapper objectMapper = new ObjectMapper();
				GCubeJWTObject obj = objectMapper.readValue(decodedAccessPart, GCubeJWTObject.class);
				owner = new Owner(obj.getUsername(), obj.getRoles(), obj.getEmail(), obj.getFirstName(), obj.getLastName(), obj.isExternalService());
				owner.setClientName(obj.getClientName());
				owner.setContactOrganisation(obj.getContactOrganisation());
				owner.setClientName(obj.getClientName());
				context = obj.getContext();

				this.accessToken = objectMapper.readValue(decodedAccessPart, AccessToken.class);

				initialised = true;
			} catch (Exception e) {
				throw new RuntimeException(e);
			}

	}

}
