package org.gcube.common.security.secrets;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.security.Owner;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class GCubeSecret extends Secret {

	public static final String GCUBE_TOKEN_REGEX = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}-[a-fA-F0-9]{8,9}){1}$";

	private String gcubeToken;
	private Owner owner;
	private String context;

	public GCubeSecret(String gcubeToken) {
		Objects.requireNonNull(gcubeToken);
		if(!Pattern.matches(GCubeSecret.GCUBE_TOKEN_REGEX, gcubeToken)) 
			throw new RuntimeException("The GUCBE token must comply with the regex " + GCUBE_TOKEN_REGEX);
		this.gcubeToken = gcubeToken;
	}

	private void init() throws Exception{
		AuthorizationEntry authorizationEntry = Constants.authorizationService().get(gcubeToken);
		this.owner = new Owner(authorizationEntry.getClientInfo().getId(), 
				authorizationEntry.getClientInfo().getRoles(), authorizationEntry.getClientInfo().getType()!=ClientType.USER);
		this.context = authorizationEntry.getContext();
	}


	@Override
	public Owner getOwner() {
		if (Objects.isNull(owner)) 
			try {
				init();
			} catch (Exception e) {
				throw new RuntimeException("error retrieving context",e);
			}

		return owner;
	}

	@Override
	public String getContext()  {
		if (Objects.isNull(context))
			try {
				init();
			} catch (Exception e) {
				throw new RuntimeException("error retrieving context",e);
			}

		return context;
	}

	@Override
	public Map<String, String> getHTTPAuthorizationHeaders() {
		Map<String, String> authorizationHeaders = new HashMap<>();
		authorizationHeaders.put(org.gcube.common.authorization.client.Constants.TOKEN_HEADER_ENTRY, gcubeToken);
		return authorizationHeaders;
	}

	@Override
	public boolean isExpired() {
		return false;
	}

}
