package org.gcube.rest.commons.db.model.app;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Table;

import org.gcube.rest.commons.db.dao.core.ConverterRecord;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.w3c.dom.Node;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

@Entity
//@SequenceGenerator(name = "SEQ_STORE", sequenceName = "run_instance_model_id_seq", allocationSize = 1)
@Table(name = "run_instance_model")
public class RunInstanceModel extends ConverterRecord<RunInstance> {
	
	private static final long serialVersionUID = 1L;
	
	@Column(name = "resourceId")
	private String resourceId;
	
	@Column(name = "ghnId")
	private String ghnId;

	@Column(name = "endpoints")
	//@ElementCollection(targetClass=String.class)
	//@CollectionOfElements
	@ElementCollection
	private Map<String, URI> endpoints;

	@Column(name = "scopes")
    @ElementCollection
	private List<String> scopes;

	@Column(name = "specificData")
	private String specificData;
	
	@Column(name = "serviceClass")
	private String serviceClass;
	
	@Column(name = "serviceName")
	private String serviceName;
	
	
	public RunInstanceModel() {
		super();
	}
	
	public RunInstanceModel(RunInstance base){
		this.copyFrom(base);
	}
	
	public String getResourceId() {
		return resourceId;
	}

	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}

	public String getGhnId() {
		return ghnId;
	}

	public void setGhnId(String ghnId) {
		this.ghnId = ghnId;
	}

	public Map<String, URI> getEndpoints() {
		return endpoints;
	}

	public void setEndpoints(Map<String, URI> endpoints) {
		this.endpoints = endpoints;
	}

	public List<String> getScopes() {
		return scopes;
	}

	public void setScopes(List<String> scopes) {
		this.scopes = scopes;
	}

	public String getSpecificData() {
		return specificData;
	}

	public void setSpecificData(String specificData) {
		this.specificData = specificData;
	}
	
	public String getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(String serviceClass) {
		this.serviceClass = serviceClass;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	///
	@Override
	public final void copyFrom(RunInstance resource){
		this.ghnId = resource.getGhnId();
		this.resourceId =  resource.getId();
		this.specificData = XMLConverter.nodeToString(resource.getSpecificData());

		this.serviceClass = resource.getServiceClass();
		this.serviceName = resource.getServiceName();
		
		if (resource.getScopes() != null)
			this.scopes = Lists.newArrayList(resource.getScopes());
		
		if (resource.getEndpoints() != null)
			this.endpoints = Maps.newHashMap(resource.getEndpoints());
	}
	
	@Override
	public final RunInstance copyTo() throws IllegalStateException {
		
		
		Node node = XMLConverter.stringToNode(this.specificData);
		if (node == null && Strings.isNullOrEmpty(this.specificData) == false){
			throw new IllegalStateException("error while creating object from convertable");
		}
		
		RunInstance resource = new RunInstance(Maps.newHashMap(this.endpoints), this.resourceId, this.ghnId, this.serviceName, this.serviceClass, Sets.newHashSet(this.scopes), node);
		
		return resource;
	}
	
}
