package org.gcube.rest.commons.publisher.resourceregistry;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.annotation.Nullable;

import org.gcube.rest.commons.inject.GcubeScope;
import org.gcube.rest.commons.inject.ResourceClass;
import org.gcube.rest.commons.inject.ResourceNamePref;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PublisherRRimpl<T extends StatefulResource> implements ResourcePublisher<T> {

	private static final Logger logger = LoggerFactory.getLogger(PublisherRRimpl.class);
	
	@SuppressWarnings("unused")
	private String scope;
	@SuppressWarnings("unused")
	private String resourceClass;
	@SuppressWarnings("unused")
	private String resourceNamePref;
	
	
	public PublisherRRimpl(){
		
	}
			
	@Inject
	public PublisherRRimpl(
			@Nullable @GcubeScope String scope, 
			@ResourceClass String resourceClass, 
			@ResourceNamePref String resourceNamePref) {
		this.scope = scope;
		this.resourceClass = resourceClass;
		this.resourceNamePref = resourceNamePref;
	}
	
	@Override
	public void deleteResource(String resourceID) throws ResourcePublisherException{
		logger.info("deleting resource with ID : " + resourceID + " from RR");
		logger.info("not implemented yet...");
	}
	
	@Override
	public void publishResource(T resource) throws ResourcePublisherException{
		logger.info("publishing resource with ID : " + resource.getResourceID() + " to RR");
		logger.info("not implemented yet...");
	}
	
	@Override
	public void updateResource(T resource) throws ResourcePublisherException {
		logger.info("updating resource with ID : " + resource.getResourceID() + " to RR");
		logger.info("not implemented yet...");
	}
}
