/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.is.discoverer.ri.icclient;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIDiscovererISHelper {
    private static final Logger logger = LoggerFactory.getLogger(RIDiscovererISHelper.class);

    public static Set<String> discoverRunningInstances(String serviceName, String serviceClass, String endpointKey, String scope) {
        logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scope : " + scope);
        HashSet<String> endpoints = new HashSet<String>();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        for (GCoreEndpoint se : resources) {
            if (se == null || se.profile() == null || se.profile().endpointMap() == null) continue;
            String status = se.profile().deploymentData().status();
            if (!status.equalsIgnoreCase("ready")) {
                logger.info("running instance : " + se.id() + " is NOT ready");
                continue;
            }
            GCoreEndpoint.Profile.Endpoint endpoint = (GCoreEndpoint.Profile.Endpoint)se.profile().endpointMap().get(endpointKey);
            if (endpoint == null || endpoint.uri() == null) continue;
            endpoints.add(endpoint.uri().toString());
        }
        logger.info("endpoints found in discovering : " + endpoints);
        return endpoints;
    }
}

