package org.gcube.rest.commons.resourceawareservice.resources;

import java.net.URI;
import java.util.Map;
import java.util.Set;

import org.w3c.dom.Node;

public class RunInstance {
	private Map<String, URI> endpoints;
	private String id;
	private String ghnId;
	private String serviceName;
	private String serviceClass;
	private Set<String> scopes;
	private Node specificData;

	/**
	 * @param endpoints
	 * @param id
	 * @param ghnId
	 * @param scopes
	 * @param specificData
	 */
	public RunInstance(Map<String, URI> endpoints, String id, String ghnId, String serviceName, String serviceClass, Set<String> scopes, Node specificData) {
		super();
		this.endpoints = endpoints;
		this.id = id;
		this.ghnId = ghnId;
		this.scopes = scopes;
		this.specificData = specificData;
	}

	/**
	 * @return the endpoints
	 */
	public Map<String, URI> getEndpoints() {
		return endpoints;
	}

	/**
	 * @param endpoints
	 *            the endpoints to set
	 */
	public void setEndpoints(Map<String, URI> endpoints) {
		this.endpoints = endpoints;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the ghnId
	 */
	public String getGhnId() {
		return ghnId;
	}

	/**
	 * @param ghnId
	 *            the ghnId to set
	 */
	public void setGhnId(String ghnId) {
		this.ghnId = ghnId;
	}

	/**
	 * @return the scopes
	 */
	public Set<String> getScopes() {
		return scopes;
	}

	/**
	 * @param scopes
	 *            the scopes to set
	 */
	public void setScopes(Set<String> scopes) {
		this.scopes = scopes;
	}
	
	
	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public String getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(String serviceClass) {
		this.serviceClass = serviceClass;
	}

	/**
	 * @return the specificData
	 */
	public Node getSpecificData() {
		return specificData;
	}

	/**
	 * @param specificData
	 *            the specificData to set
	 */
	public void setSpecificData(Node specificData) {
		this.specificData = specificData;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RunInstance [endpoints=" + endpoints + ", id=" + id
				+ ", ghnId=" + ghnId + ", serviceName=" + serviceName
				+ ", serviceClass=" + serviceClass + ", scopes=" + scopes
				+ ", specificData=" + specificData + "]";
	}
}
