/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.resourceawareservice.resources;

import java.io.StringWriter;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Resource
extends GeneralResource {
    private static final long serialVersionUID = 1L;
    private String name;
    private String type;
    private List<String> scopes;
    private String description;
    private Node body;

    public Resource() {
        this.setResourceID(UUID.randomUUID().toString());
        this.newBody();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Node getBody() {
        return this.body;
    }

    public Resource newBody() {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(document.createElement("doc"));
            this.body = document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return this;
    }

    public String getBodyAsString() {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(this.body), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        return sw.toString();
    }

    public void setBody(Node body) {
        this.body = body;
    }

    public String toString() {
        return "Resource [id=" + this.getResourceID() + ", name=" + this.name + ", scopes=" + this.scopes + ", description=" + this.description + ", body=" + this.body + "]";
    }
}

