/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingBlockService {
    public static List<BuildingBlock> getBuildingBlocks() {
        List<BuildingBlock> buildingBlocks = BuildingBlockService.getPredefinedBuildingBlocks();
        buildingBlocks.addAll(BuildingBlockService.getPluginBuildingBlocks());
        buildingBlocks.addAll(BuildingBlockService.getUserBuildingBlocks());
        Collections.sort(buildingBlocks);
        return buildingBlocks;
    }

    public static List<BuildingBlock> getUserBuildingBlocks() {
        File[] userDefinedBuildingBlockFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        File[] fileArray = userDefinedBuildingBlockFiles;
        int n = userDefinedBuildingBlockFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                buildingBlocks.add(new BuildingBlock(file));
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot load building block file '" + file + "': " + e.getMessage(), 6);
            }
            ++n2;
        }
        return buildingBlocks;
    }

    public static List<BuildingBlock> getPredefinedBuildingBlocks() {
        File bbDirectory = ParameterService.getConfigFile("buildingblocks");
        File[] preDefinedBuildingBlockFiles = bbDirectory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        if (preDefinedBuildingBlockFiles != null) {
            File[] fileArray = preDefinedBuildingBlockFiles;
            int n = preDefinedBuildingBlockFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    buildingBlocks.add(new BuildingBlock(file));
                }
                catch (InstantiationException e) {
                    LogService.getGlobal().log("Cannot load building block file '" + file + "': " + e.getMessage(), 6);
                }
                ++n2;
            }
        }
        return buildingBlocks;
    }

    public static List<BuildingBlock> getPluginBuildingBlocks() {
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        Iterator<Plugin> p = Plugin.getAllPlugins().iterator();
        while (p.hasNext()) {
            buildingBlocks.addAll(p.next().getBuildingBlocks());
        }
        return buildingBlocks;
    }
}

