/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.test;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.test.ExampleSetSampleTest;
import com.rapidminer.test.IOObjectSampleTest;
import com.rapidminer.test.PerformanceSampleTest;
import com.rapidminer.test.RapidMinerTestCase;
import com.rapidminer.test.SimpleSampleTest;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SampleTest
extends RapidMinerTestCase {
    private String file;

    public SampleTest(String file) {
        super("sampleTest");
        this.file = file;
    }

    public String getName() {
        return "Sample '" + this.file + "'";
    }

    public void sampleTest() throws Exception {
        File processFile = new File(ParameterService.getRapidMinerHome(), "sample" + File.separator + this.file);
        if (!processFile.exists()) {
            throw new Exception("File '" + processFile.getAbsolutePath() + "' does not exist!");
        }
        LogService.getGlobal().setVerbosityLevel(9);
        Process process = RapidMiner.readProcessFile(processFile);
        IOContainer output = process.run(new IOContainer(), 9);
        this.checkOutput(output);
    }

    public abstract void checkOutput(IOContainer var1) throws MissingIOObjectException;

    public static Test suite() {
        TestSuite suite = new TestSuite("Sample test");
        suite.addTest((Test)new SimpleSampleTest("Empty.xml"));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "01_ExampleSource.xml", 14, 4));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "02_ArffExampleSource.xml", 150, 4));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "03_Sparse.xml", 4, 30));
        suite.addTest((Test)new IOObjectSampleTest("01_IO" + File.separator + "04_C45ExampleSource.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "05_CSVExampleSource.xml", 14, 4));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "08_ExampleSourceFromMultipleSources.xml", 14, 4));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "11_ExampleSetWriter.xml", 14, 4));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "12_ExampleSetWriterPredictions.xml", 14, 4, new String[]{"prediction"}));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "13_ArffExampleSetWriter.xml", 14, 4));
        suite.addTest((Test)new IOObjectSampleTest("01_IO" + File.separator + "18_ModelWriter.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new ExampleSetSampleTest("01_IO" + File.separator + "19_ModelLoader.xml", 14, 4, new String[]{"prediction"}));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "01_DecisionTree.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "02_LinearRegression.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "03_NeuralNetwork.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "04_NearestNeighbors.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "05_NaiveBayes.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "06_SupportVectorMachine.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "07_LogisticRegression.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "08_RuleLearning.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "09_Bagging.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new IOObjectSampleTest("02_Learner" + File.separator + "10_Boosting.xml", SampleTest.createClassCollection(new Class[]{Model.class})));
        suite.addTest((Test)new ExampleSetSampleTest("02_Learner" + File.separator + "11_ModelApplier.xml", 14, 4, new String[]{"prediction"}));
        suite.addTest((Test)new PerformanceSampleTest("02_Learner" + File.separator + "13_AsymmetricCostLearning.xml", new String[]{"accuracy"}, new double[]{0.725}));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "01_Normalization.xml", 150, 4));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "02_IdTagging.xml", 150, 4, new String[]{"id"}));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "03_Sampling.xml", 29, 4));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "04_Discretization.xml", 208, 60));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "05_MinimalEntropyPartitioning.xml", 208, 21));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "06_ExampleFilter.xml", 1, 16));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "07_MissingValueReplenishment.xml", 40, 16));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "08_NoiseGenerator.xml", 200, 8));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "09_MergingAndRemoving.xml", 8, 2));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "10_RemoveCorrelatedFeatures.xml", 208, 21));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "11_RemoveUselessAttributes.xml", 208, 38));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "12_FeatureGenerationByUser.xml", 200, 8));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "14_StratifiedSampling.xml", 40, 2));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "19_AttributeSubsetPreprocessing.xml", 14, 4));
        suite.addTest((Test)new ExampleSetSampleTest("03_Preprocessing" + File.separator + "22_CreateAndNameOutlierCluster.xml", 200, 2));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "01_PerformanceEvaluator_Nominal.xml", new String[]{"accuracy"}, new double[]{0.875}));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "02_PerformanceEvaluator_Regression.xml", new String[]{"relative_error_lenient"}, new double[]{0.306774}));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "03_XValidation_Numerical.xml", new String[]{"correlation"}, new double[]{0.999077}));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "04_XValidation_Nominal.xml", new String[]{"classification_error"}, new double[]{0.075}));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "07_AreaUnderCurve.xml", new String[]{"AUC"}, new double[]{0.980017}));
        suite.addTest((Test)new PerformanceSampleTest("04_Validation" + File.separator + "08_SimpleValidation.xml", new String[]{"accuracy"}, new double[]{0.866666}));
        suite.addTest((Test)new ExampleSetSampleTest("05_Features" + File.separator + "03_PrincipalComponents.xml", 150, 2));
        suite.addTest((Test)new PerformanceSampleTest("05_Features" + File.separator + "09_FeatureSelectionFilter.xml", new String[]{"CorrelationFS"}, new double[]{0.834588}));
        suite.addTest((Test)new PerformanceSampleTest("05_Features" + File.separator + "10_ForwardSelection.xml", new String[]{"root_mean_squared_error"}, new double[]{37.495692}));
        suite.addTest((Test)new PerformanceSampleTest("05_Features" + File.separator + "19_YAGGA.xml", new String[]{"root_relative_squared_error"}, new double[]{0.0386407}));
        suite.addTest((Test)new ExampleSetSampleTest("05_Features" + File.separator + "20_YAGGAResultAttributeSetting.xml", 200, 10));
        suite.addTest((Test)new PerformanceSampleTest("07_Meta" + File.separator + "01_ParameterOptimization.xml", new String[]{"absolute_error"}, new double[]{8.377368}));
        suite.addTest((Test)new SimpleSampleTest("07_Meta" + File.separator + "02_ParameterSetter.xml"));
        suite.addTest((Test)new SimpleSampleTest("07_Meta" + File.separator + "04_LearningCurve.xml"));
        suite.addTest((Test)new PerformanceSampleTest("07_Meta" + File.separator + "05_MultipleLabelLearning.xml", new String[]{"accuracy"}, new double[]{0.893333}));
        suite.addTest((Test)new ExampleSetSampleTest("09_Other" + File.separator + "02_Obfuscation.xml", 14, 4));
        return suite;
    }

    private static Collection<Class<IOObject>> createClassCollection(Class[] classes) {
        LinkedList<Class<IOObject>> result = new LinkedList<Class<IOObject>>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            result.add(clazz);
            ++n2;
        }
        return result;
    }
}

