/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExponentialSmoothing
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_ALPHA = "alpha";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public ExponentialSmoothing(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        Attribute smoothedAttribute = AttributeFactory.createAttribute("exponential_smoothing(" + attribute.getName() + ")", 2);
        exampleSet.getExampleTable().addAttribute(smoothedAttribute);
        exampleSet.getAttributes().addRegular(smoothedAttribute);
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
        double smoothedValue = 0.0;
        int index = 0;
        for (Example example : exampleSet) {
            example.setValue(smoothedAttribute, Double.NaN);
            if (index < 1) {
                smoothedValue = example.getValue(attribute);
                example.setValue(smoothedAttribute, smoothedValue);
                ++index;
                continue;
            }
            double value = example.getValue(attribute);
            if (ignoreMissings && Double.isNaN(value)) {
                example.setValue(smoothedAttribute, Double.NaN);
            } else {
                smoothedValue = alpha * value + (1.0 - alpha) * smoothedValue;
                example.setValue(smoothedAttribute, smoothedValue);
            }
            ++index;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.recalculateAttributeStatistics(smoothedAttribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the series attribute which should be smoothed.", false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_ALPHA, "The value alpha which determines the weight of past and present values.", 0.0, 1.0, 0.5);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Ignore missing values in the smoothing procedure. If false, missing values in original series lead to missing values in the smoothed series from that point on.", true);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true);
        types.add(type);
        return types;
    }
}

