/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterConditions;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFilter
extends AbstractFeatureSelection {
    public static final String PARAMETER_INVERT_FILTER = "invert_filter";
    public static final String PARAMETER_APPLY_ON_SPECIAL = "apply_on_special";

    public AttributeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        AttributeFilterCondition condition = AttributeFilterConditions.createCondition(this);
        boolean invert = this.getParameterAsBoolean(PARAMETER_INVERT_FILTER);
        LinkedList<Attribute> remainingAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> iterator = null;
        iterator = this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL) ? attributes.allAttributes() : attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            AttributeFilterCondition.ScanResult result = condition.beforeScanCheck(attribute).invert(invert);
            switch (result) {
                case KEEP: 
                case UNCHECKED: {
                    remainingAttributes.add(attribute);
                    break;
                }
                case REMOVE: {
                    iterator.remove();
                }
            }
        }
        if (condition.isNeedingScan()) {
            for (Attribute attribute : remainingAttributes) {
                AttributeFilterCondition.ScanResult afterScanResult = AttributeFilterCondition.ScanResult.UNCHECKED;
                for (Example example : exampleSet) {
                    AttributeFilterCondition.ScanResult result = condition.check(attribute, example);
                    if (result == AttributeFilterCondition.ScanResult.UNCHECKED) continue;
                    afterScanResult = result;
                    break;
                }
                if (condition.isNeedingFullScan()) {
                    afterScanResult = condition.checkAfterFullScan();
                } else if (afterScanResult == AttributeFilterCondition.ScanResult.UNCHECKED) {
                    afterScanResult = AttributeFilterCondition.ScanResult.KEEP;
                }
                afterScanResult = afterScanResult.invert(invert);
                if (afterScanResult != AttributeFilterCondition.ScanResult.REMOVE) continue;
                exampleSet.getAttributes().remove(attribute);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(AttributeFilterConditions.getParameterTypes(this));
        types.add(new ParameterTypeBoolean(PARAMETER_INVERT_FILTER, "Indicates if only attributes should be accepted which would normally filtered.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_SPECIAL, "Indicate if this operator should also be applied on the special attributes.", false));
        return types;
    }
}

