/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.postprocessing.Threshold;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdCreator
extends Operator {
    public static final String PARAMETER_THRESHOLD = "threshold";
    public static final String PARAMETER_FIRST_CLASS = "first_class";
    public static final String PARAMETER_SECOND_CLASS = "second_class";

    public ThresholdCreator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        double threshold = this.getParameterAsDouble(PARAMETER_THRESHOLD);
        String negativeClass = this.getParameterAsString(PARAMETER_FIRST_CLASS);
        String positiveClass = this.getParameterAsString(PARAMETER_SECOND_CLASS);
        return new IOObject[]{new Threshold(threshold, negativeClass, positiveClass)};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{Threshold.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_THRESHOLD, "The confidence threshold to determine if the prediction should be positive.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        list.add(type);
        list.add(new ParameterTypeString(PARAMETER_FIRST_CLASS, "The class which should be considered as the first one (confidence 0).", false));
        list.add(new ParameterTypeString(PARAMETER_SECOND_CLASS, "The class which should be considered as the second one (confidence 1).", false));
        return list;
    }
}

