/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.AbstractCriterion;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;

public class AccuracyCriterion
extends AbstractCriterion {
    private FrequencyCalculator frequencyCalculator = new FrequencyCalculator();

    public double getNominalBenefit(ExampleSet exampleSet, Attribute attribute) {
        double[][] weightCounts = this.frequencyCalculator.getNominalWeightCounts(exampleSet, attribute);
        return this.getBenefit(weightCounts);
    }

    public double getNumericalBenefit(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        double[][] weightCounts = this.frequencyCalculator.getNumericalWeightCounts(exampleSet, attribute, splitValue);
        return this.getBenefit(weightCounts);
    }

    protected double getBenefit(double[][] weightCounts) {
        double sum = 0.0;
        int v = 0;
        while (v < weightCounts.length) {
            int maxIndex = -1;
            double maxValue = Double.NEGATIVE_INFINITY;
            double currentSum = 0.0;
            int l = 0;
            while (l < weightCounts[v].length) {
                if (weightCounts[v][l] > maxValue) {
                    maxIndex = l;
                    maxValue = weightCounts[v][l];
                }
                currentSum += weightCounts[v][l];
                ++l;
            }
            sum += weightCounts[v][maxIndex] / currentSum;
            ++v;
        }
        return sum;
    }

    public boolean supportsIncrementalCalculation() {
        return true;
    }

    public double getIncrementalBenefit() {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        double currentSum = 0.0;
        int j = 0;
        while (j < this.leftLabelWeights.length) {
            if (this.leftLabelWeights[j] > maxValue) {
                maxIndex = j;
                maxValue = this.leftLabelWeights[j];
            }
            currentSum += this.leftLabelWeights[j];
            ++j;
        }
        double sum = this.leftLabelWeights[maxIndex] / currentSum;
        maxIndex = -1;
        maxValue = Double.NEGATIVE_INFINITY;
        currentSum = 0.0;
        int j2 = 0;
        while (j2 < this.rightLabelWeights.length) {
            if (this.rightLabelWeights[j2] > maxValue) {
                maxIndex = j2;
                maxValue = this.rightLabelWeights[j2];
            }
            currentSum += this.rightLabelWeights[j2];
            ++j2;
        }
        return sum + this.rightLabelWeights[maxIndex] / currentSum;
    }
}

