/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import java.io.Serializable;

public class ContingencyMatrix
implements Serializable {
    private static final long serialVersionUID = -4919765585974259997L;
    private final double[][] matrix;
    private final double[] rowSums;
    private final double[] colSums;
    private final double total;

    public ContingencyMatrix(double[][] contigencyMatrix) {
        this.matrix = new double[contigencyMatrix.length][];
        int i = 0;
        while (i < this.matrix.length) {
            this.matrix[i] = new double[contigencyMatrix[i].length];
            System.arraycopy(contigencyMatrix[i], 0, this.matrix[i], 0, this.matrix[i].length);
            ++i;
        }
        double totalSum = 0.0;
        this.rowSums = new double[this.matrix.length];
        int row = 0;
        while (row < this.rowSums.length) {
            double prior = 0.0;
            double[] entries = this.matrix[row];
            int i2 = 0;
            while (i2 < entries.length) {
                prior += entries[i2];
                ++i2;
            }
            this.rowSums[row] = prior;
            totalSum += prior;
            ++row;
        }
        this.total = totalSum;
        this.colSums = new double[this.matrix.length > 0 ? this.matrix[0].length : 0];
        int col = 0;
        while (col < this.colSums.length) {
            double sum = 0.0;
            int i3 = 0;
            while (i3 < this.matrix.length) {
                sum += this.matrix[i3][col];
                ++i3;
            }
            this.colSums[col] = sum;
            ++col;
        }
    }

    public double[][] getMatrix() {
        double[][] result = new double[this.matrix.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = new double[this.matrix[i].length];
            System.arraycopy(this.matrix[i], 0, result[i], 0, this.matrix[i].length);
            ++i;
        }
        return result;
    }

    public int getNumberOfClasses() {
        return this.rowSums.length;
    }

    public int getNumberOfPredictions() {
        return this.colSums.length;
    }

    public double[] getPriors() {
        double[] priors = new double[this.rowSums.length];
        int i = 0;
        while (i < priors.length) {
            priors[i] = this.getPrior(i);
            ++i;
        }
        return priors;
    }

    public double getPrior(int trueLabel) {
        return this.rowSums[trueLabel] / this.total;
    }

    public double getCoverage(int predictedLabel) {
        return this.colSums[predictedLabel] / this.total;
    }

    public double getProbability(int trueLabel, int predictedLabel) {
        return this.matrix[trueLabel][predictedLabel] / this.total;
    }

    public double getPrecision(int trueLabel, int predictedLabel) {
        return this.getProbability(trueLabel, predictedLabel) / this.getCoverage(predictedLabel);
    }

    public double getLift(int trueLabel, int predictedLabel) {
        if (this.getCoverage(predictedLabel) <= 0.0) {
            return Double.NaN;
        }
        return this.getPrecision(trueLabel, predictedLabel) / this.getPrior(trueLabel);
    }

    public double getLiftRatio(int trueLabel, int predictedLabel) {
        double liftPos = this.getLift(trueLabel, predictedLabel);
        if (Double.isNaN(liftPos) || Double.isInfinite(liftPos)) {
            return liftPos;
        }
        double precNeg = 1.0 - this.getPrecision(trueLabel, predictedLabel);
        double priorNeg = 1.0 - this.getPrior(trueLabel);
        if (priorNeg <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double liftNeg = precNeg / priorNeg;
        return liftPos / liftNeg;
    }

    public double[] getLiftRatiosForPrediction(int predictedLabel) {
        double[] liftRatios = new double[this.matrix.length];
        int i = 0;
        while (i < liftRatios.length) {
            liftRatios[i] = this.getLiftRatio(i, predictedLabel);
            ++i;
        }
        return liftRatios;
    }

    public double getAccuracy() {
        double sum = 0.0;
        int row = 0;
        while (row < this.matrix.length) {
            if (this.matrix[row].length > row) {
                sum += this.matrix[row][row];
            }
            ++row;
        }
        return sum / this.total;
    }

    public double getErrorRate() {
        return 1.0 - this.getAccuracy();
    }

    public double getTotalWeight() {
        return this.total;
    }

    public ContingencyMatrix clone() {
        return new ContingencyMatrix(this.matrix);
    }
}

