/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.Optimization;
import com.rapidminer.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSOWeighting
extends OperatorChain {
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_INERTIA_WEIGHT = "inertia_weight";
    public static final String PARAMETER_LOCAL_BEST_WEIGHT = "local_best_weight";
    public static final String PARAMETER_GLOBAL_BEST_WEIGHT = "global_best_weight";
    public static final String PARAMETER_DYNAMIC_INERTIA_WEIGHT = "dynamic_inertia_weight";
    public static final String PARAMETER_MIN_WEIGHT = "min_weight";
    public static final String PARAMETER_MAX_WEIGHT = "max_weight";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private Optimization optimization;
    private ExampleSet exampleSet;

    public PSOWeighting(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("generation", "The number of the current generation."){

            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getGeneration();
            }
        });
        this.addValue(new ValueDouble("performance", "The performance of the current generation (main criterion)."){

            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getBestFitnessInGeneration();
            }
        });
        this.addValue(new ValueDouble("best", "The performance of the best individual ever (main criterion)."){

            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getBestFitnessEver();
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.exampleSet = this.getInput(ExampleSet.class);
        this.optimization = new PSOWeightingOptimization(this, this.exampleSet.getAttributes().size(), RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)));
        this.optimization.optimize();
        double[] globalBestWeights = this.optimization.getBestValuesEver();
        AttributeWeightedExampleSet result = this.createWeightedExampleSet(globalBestWeights);
        AttributeWeights weights = new AttributeWeights();
        int index = 0;
        for (Attribute attribute : result.getAttributes()) {
            weights.setWeight(attribute.getName(), globalBestWeights[index++]);
        }
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.normalize();
        }
        return new IOObject[]{result, weights, this.optimization.getBestPerformanceEver()};
    }

    private PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
        boolean onlyZeros = true;
        int i = 0;
        while (i < individual.length) {
            if (individual[i] != 0.0) {
                onlyZeros = false;
                break;
            }
            ++i;
        }
        if (onlyZeros) {
            return null;
        }
        AttributeWeightedExampleSet evaluationSet = this.createWeightedExampleSet(individual).createCleanClone();
        Operator operatorChain = this.getOperator(0);
        IOObject[] operatorChainInput = new IOObject[]{evaluationSet};
        IOContainer innerResult = operatorChain.apply(this.getInput().append(operatorChainInput));
        return innerResult.remove(PerformanceVector.class);
    }

    private AttributeWeightedExampleSet createWeightedExampleSet(double[] weights) {
        AttributeWeightedExampleSet result = new AttributeWeightedExampleSet(this.exampleSet, null);
        int index = 0;
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            result.setWeight(attribute, weights[index++]);
        }
        return result;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class});
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Activates the normalization of all weights.", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble(PARAMETER_INERTIA_WEIGHT, "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_LOCAL_BEST_WEIGHT, "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_GLOBAL_BEST_WEIGHT, "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_DYNAMIC_INERTIA_WEIGHT, "If set to true the inertia weight is improved during run.", true));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_WEIGHT, "The lower bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_MAX_WEIGHT, "The upper bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }

    private static class PSOWeightingOptimization
    extends PSOOptimization {
        private final PSOWeighting op;

        public PSOWeightingOptimization(PSOWeighting op, int individualSize, RandomGenerator random) throws UndefinedParameterError {
            super(op.getParameterAsInt(PSOWeighting.PARAMETER_POPULATION_SIZE), individualSize, op.getParameterAsInt(PSOWeighting.PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS), op.getParameterAsInt(PSOWeighting.PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), op.getParameterAsDouble(PSOWeighting.PARAMETER_INERTIA_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_LOCAL_BEST_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_GLOBAL_BEST_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_MIN_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_MAX_WEIGHT), op.getParameterAsBoolean(PSOWeighting.PARAMETER_DYNAMIC_INERTIA_WEIGHT), random);
            this.op = op;
        }

        public PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
            return this.op.evaluateIndividual(individual);
        }

        public void nextIteration() throws OperatorException {
            super.nextIteration();
            this.op.inApplyLoop();
        }
    }
}

