/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class TournamentSelection
implements PopulationOperator {
    private int popSize;
    private double tournamentFraction;
    private double delta = 0.0;
    private boolean keepBest = false;
    private Random random;

    public TournamentSelection(int popSize, double tournamentFraction, int maxGenerations, boolean dynamic, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.tournamentFraction = tournamentFraction;
        if (dynamic) {
            this.delta = (1.0 - this.tournamentFraction) / (double)(maxGenerations + 1);
        }
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        int tournamentSize = Math.max((int)Math.round((double)population.getNumberOfIndividuals() * this.tournamentFraction), 1);
        if (this.keepBest) {
            newGeneration.add(population.getBestIndividualEver());
        }
        while (newGeneration.size() < this.popSize) {
            Individual winner = null;
            int k = 0;
            while (k < tournamentSize) {
                Individual current = population.get(this.random.nextInt(population.getNumberOfIndividuals()));
                if (winner == null || current.getPerformance().getMainCriterion().getFitness() > winner.getPerformance().getMainCriterion().getFitness()) {
                    winner = current;
                }
                ++k;
            }
            newGeneration.add(winner);
        }
        population.clear();
        population.addAllIndividuals(newGeneration);
        this.tournamentFraction += this.delta;
    }
}

