/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.GeneratingMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAGGA
extends AbstractGeneratingGeneticAlgorithm {
    public static final String PARAMETER_P_MUTATION = "p_mutation";
    public static final String PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "max_total_number_of_attributes";

    public YAGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getGeneratingPopulationOperator(ExampleSet exampleSet) {
        return null;
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.logWarning("No FeatureGenerators specified for " + this.getName() + ".");
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (Attribute attribute : eSet.getAttributes()) {
            attributes.add(attribute);
        }
        double pMutation = this.getParameterAsDouble(PARAMETER_P_MUTATION);
        int maxNumberOfAttributes = this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES);
        return new GeneratingMutation(attributes, pMutation, maxNumberOfAttributes, generators, this.getRandom());
    }

    @Override
    public ExampleSetBasedPopulation createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        ExampleSetBasedPopulation population = super.createInitialPopulation(es);
        ExampleSetBasedPopulation popRemovedDeselected = new ExampleSetBasedPopulation();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            popRemovedDeselected.add(new ExampleSetBasedIndividual(population.get(i).getExampleSet().createCleanClone()));
            ++i;
        }
        return popRemovedDeselected;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for mutation (-1: 1/n).", 0.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Max total number of attributes in all generations (-1: no maximum).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

