/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.operator.clustering.clusterer.SVCExampleSet;
import com.rapidminer.operator.clustering.clusterer.SVClusteringAlgorithm;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExample;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelDot;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelNeural;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelPolynomial;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelRadial;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVClustering
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String MIN_PTS_NAME = "min_pts";
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_KERNEL_GAMMA = "kernel_gamma";
    public static final String PARAMETER_KERNEL_DEGREE = "kernel_degree";
    public static final String PARAMETER_KERNEL_A = "kernel_a";
    public static final String PARAMETER_KERNEL_B = "kernel_b";
    public static final String PARAMETER_KERNEL_CACHE = "kernel_cache";
    public static final String PARAMETER_CONVERGENCE_EPSILON = "convergence_epsilon";
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_R = "r";
    public static final String PARAMETER_NUMBER_SAMPLE_POINTS = "number_sample_points";
    private static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "neural"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_NEURAL = 3;
    protected static final int UNASSIGNED = -1;
    public static final int NOISE = 0;
    public static final String NOISE_CLUSTER_DESCRIPTION = "Outliers";

    public SVClustering(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "AgglomerativeClustering");
        Tools.isNonEmpty(exampleSet);
        int kernelType = this.getParameterAsInt(PARAMETER_KERNEL_TYPE);
        int cacheSize = this.getParameterAsInt(PARAMETER_KERNEL_CACHE);
        Kernel kernel = SVClustering.createKernel(kernelType);
        if (kernelType == 1) {
            ((KernelRadial)kernel).setGamma(this.getParameterAsDouble(PARAMETER_KERNEL_GAMMA));
        } else if (kernelType == 2) {
            ((KernelPolynomial)kernel).setDegree(this.getParameterAsInt(PARAMETER_KERNEL_DEGREE));
        } else if (kernelType == 3) {
            ((KernelNeural)kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_A), this.getParameterAsDouble(PARAMETER_KERNEL_B));
        }
        SVCExampleSet svmExamples = new SVCExampleSet(exampleSet, false);
        kernel.init(svmExamples, cacheSize);
        SVClusteringAlgorithm clustering = new SVClusteringAlgorithm(this, kernel, svmExamples);
        clustering.train();
        int nextClusterId = 0;
        int minPts = this.getParameterAsInt(MIN_PTS_NAME);
        int[] clusterAssignments = new int[exampleSet.size()];
        Arrays.fill(clusterAssignments, -1);
        int i = 0;
        for (Example example : exampleSet) {
            if (clusterAssignments[i] == -1) {
                LinkedList<Integer> neighbours = this.getNeighbours(exampleSet, example, i, clusterAssignments, clustering);
                if (neighbours.size() >= minPts) {
                    clusterAssignments[i] = ++nextClusterId;
                    Iterator iterator = neighbours.iterator();
                    while (iterator.hasNext()) {
                        int exampleIndex = (Integer)iterator.next();
                        clusterAssignments[exampleIndex] = nextClusterId;
                    }
                    while (neighbours.size() > 0) {
                        int index = neighbours.poll();
                        Example neighbourExample = exampleSet.getExample(index);
                        LinkedList<Integer> neighboursRecursive = this.getNeighbours(exampleSet, neighbourExample, index, clusterAssignments, clustering);
                        if (neighboursRecursive.size() < minPts) continue;
                        Iterator iterator2 = neighboursRecursive.iterator();
                        while (iterator2.hasNext()) {
                            int recursiveIndex = (Integer)iterator2.next();
                            if (clusterAssignments[recursiveIndex] == -1) {
                                neighbours.add(recursiveIndex);
                            }
                            clusterAssignments[recursiveIndex] = nextClusterId;
                        }
                    }
                } else {
                    clusterAssignments[i] = 0;
                }
            }
            ++i;
        }
        ClusterModel model = new ClusterModel(nextClusterId + 1);
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean("keep_example_set")) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            i = 0;
            for (Example example : exampleSet) {
                if (clusterAssignments[i] == 0) {
                    example.setValue(cluster, "noise");
                } else {
                    example.setValue(cluster, "cluster_" + clusterAssignments[i]);
                }
                ++i;
            }
        }
        return model;
    }

    protected LinkedList<Integer> getNeighbours(ExampleSet exampleSet, Example centroid, int centroidIndex, int[] assignments, SVClusteringAlgorithm clustering) throws UndefinedParameterError {
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        double paramR = this.getParameterAsDouble(PARAMETER_R);
        double maxRadius = paramR < 0.0 ? clustering.getR() : paramR;
        int numSamplePoints = this.getParameterAsInt(PARAMETER_NUMBER_SAMPLE_POINTS);
        int i = 0;
        for (Example example : exampleSet) {
            if (i != centroidIndex && assignments[i] == -1) {
                double[] directions = new double[centroid.getAttributes().size()];
                int x = 0;
                for (Attribute attribute : centroid.getAttributes()) {
                    directions[x++] = example.getValue(attribute) - centroid.getValue(attribute);
                }
                boolean addAsNeighbor = true;
                int j = 0;
                while (j < numSamplePoints) {
                    if (!addAsNeighbor) break;
                    double[] virtualExample = new double[directions.length];
                    x = 0;
                    for (Attribute attribute : centroid.getAttributes()) {
                        virtualExample[x] = centroid.getValue(attribute) + (double)(j + 1) * directions[x] / (double)(numSamplePoints + 1);
                        ++x;
                    }
                    SVMExample svmExample = new SVMExample(virtualExample);
                    double currentRadius = clustering.predict(svmExample);
                    if (currentRadius > maxRadius) {
                        addAsNeighbor = false;
                        break;
                    }
                    ++j;
                }
                if (addAsNeighbor) {
                    neighbors.add(i);
                }
            }
            ++i;
        }
        return neighbors;
    }

    public static Kernel createKernel(int kernelType) {
        switch (kernelType) {
            case 1: {
                return new KernelRadial();
            }
            case 2: {
                return new KernelPolynomial();
            }
            case 3: {
                return new KernelNeural();
            }
        }
        return new KernelDot();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        type = new ParameterTypeInt(MIN_PTS_NAME, "The minimal number of points in each cluster.", 0, Integer.MAX_VALUE, 2);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNEL_TYPE, "The SVM kernel type", KERNEL_TYPES, 1);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_GAMMA, "The SVM kernel parameter gamma (radial).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNEL_DEGREE, "The SVM kernel parameter degree (polynomial).", 0, Integer.MAX_VALUE, 2);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_A, "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_B, "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_KERNEL_CACHE, "Size of the cache for kernel evaluations im MB ", 0, Integer.MAX_VALUE, 200));
        type = new ParameterTypeDouble(PARAMETER_CONVERGENCE_EPSILON, "Precision on the KKT conditions", 0.0, Double.POSITIVE_INFINITY, 0.001);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "Stop after this many iterations", 1, Integer.MAX_VALUE, 100000));
        type = new ParameterTypeDouble(PARAMETER_P, "The fraction of allowed outliers.", 0.0, 1.0, 0.0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_R, "Use this radius instead of the calculated one (-1 for calculated radius).", -1.0, Double.POSITIVE_INFINITY, -1.0);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_SAMPLE_POINTS, "The number of virtual sample points to check for neighborship.", 1, Integer.MAX_VALUE, 20));
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

