/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ExtendedCheckTreeCellRenderer;
import com.rapidminer.gui.tools.ExtendedCheckTreeSelectionModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ExtendedCheckTreeMouseSelectionManager
extends MouseAdapter
implements TreeSelectionListener {
    private ExtendedCheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;

    public ExtendedCheckTreeMouseSelectionManager(JTree tree, boolean selectAll) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = tree;
        this.selectionModel = new ExtendedCheckTreeSelectionModel(tree.getModel());
        if (selectAll) {
            this.selectionModel.addSelectionPath(tree.getPathForRow(0));
        }
        tree.setCellRenderer(new ExtendedCheckTreeCellRenderer(new DefaultTreeCellRenderer(), this.selectionModel));
        tree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    public void mouseClicked(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        boolean selected = this.selectionModel.isPathSelected(path, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
        }
    }

    public ExtendedCheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.tree.treeDidChange();
    }
}

