/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.FrameIconProvider;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFrameIconProvider
implements FrameIconProvider {
    private String frameIconBaseName;

    public DefaultFrameIconProvider(String frameIconBaseName) {
        this.frameIconBaseName = frameIconBaseName;
    }

    @Override
    public List<Image> getFrameIcons() {
        try {
            LinkedList<Image> frameIcons = new LinkedList<Image>();
            String[] stringArray = FRAME_ICON_SIZES;
            int n = FRAME_ICON_SIZES.length;
            int n2 = 0;
            while (n2 < n) {
                String size = stringArray[n2];
                URL url = Tools.getResource(String.valueOf(this.frameIconBaseName) + size + ".png");
                if (url != null) {
                    frameIcons.add(ImageIO.read(url));
                }
                ++n2;
            }
            return frameIcons;
        }
        catch (IOException e) {
            LogService.getGlobal().logWarning("Cannot load frame icons. Skipping...");
            return new LinkedList<Image>();
        }
    }
}

