/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.charts.Abstract2DChartPlotter;
import com.rapidminer.gui.plotter.charts.ColorizedShapeItemRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class ScatterPlotter2
extends Abstract2DChartPlotter {
    private static final long serialVersionUID = 6535057074946396896L;

    public AbstractXYItemRenderer getItemRenderer(boolean nominal, int size, double minColor, double maxColor) {
        if (nominal) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
            renderer.setUseOutlinePaint(true);
            renderer.setDrawOutlines(true);
            if (size > 1) {
                int i = 0;
                while (i < size) {
                    renderer.setSeriesPaint(i, (Paint)this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                    renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
                    ++i;
                }
            } else {
                renderer.setSeriesPaint(0, (Paint)this.getColorProvider().getPointColor(1.0));
                renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
            }
            return renderer;
        }
        ColorizedShapeItemRenderer renderer = new ColorizedShapeItemRenderer(minColor, maxColor);
        renderer.setBaseOutlinePaint(Color.BLACK);
        renderer.setUseOutlinePaint(true);
        renderer.setDrawOutlines(true);
        renderer.setSeriesShape(0, new Ellipse2D.Double(-3.0, -3.0, 7.0, 7.0));
        return renderer;
    }
}

