/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Browser
extends JEditorPane
implements HyperlinkListener {
    private static final long serialVersionUID = -2342332990027338104L;

    public Browser() {
        this.setEditable(false);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)this.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.setPage(e.getURL());
                }
                catch (Throwable t) {
                    SwingTools.showSimpleErrorMessage("While following link:", t);
                }
            }
        }
    }

    private JMenuItem createItem(String name, final URL url) {
        if (url != null) {
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Browser.this.setPage(url);
                    }
                    catch (IOException t) {
                        SwingTools.showSimpleErrorMessage("Cannot find '" + url + "'", t);
                    }
                }
            });
            return item;
        }
        return null;
    }

    public static void showDialog(URL url) {
        Browser browser = new Browser();
        JDialog dialog = new JDialog();
        dialog.setTitle("RapidMiner Browser");
        JMenuBar menuBar = new JMenuBar();
        JMenu visitMenu = new JMenu("Browse");
        JMenuItem item = browser.createItem("RapidMiner GUI Manual", Tools.getResource("manual/RapidMinerGUIManual.html"));
        if (item != null) {
            visitMenu.add(item);
        } else {
            LogService.getGlobal().log("Cannot show GUI manual: resource 'manual/RapidMinerGUIManual.html' not found...", 5);
        }
        try {
            item = browser.createItem("RapidMiner@WWW", new URL("http://www.rapidminer.com"));
            if (item != null) {
                visitMenu.add(item);
            } else {
                LogService.getGlobal().log("Cannot show RapidMiner web site: URL 'http://www.rapidminer.com' not found...", 5);
            }
        }
        catch (MalformedURLException e) {
            LogService.getGlobal().log("Cannot show RapidMiner web site: " + e.getMessage(), 5);
        }
        item = browser.createItem("License", Tools.getResource("LICENSE.html"));
        if (item != null) {
            visitMenu.add(item);
        } else {
            LogService.getGlobal().log("Cannot show license: resource 'LICENSE.html' not found...", 5);
        }
        menuBar.add(visitMenu);
        dialog.setJMenuBar(menuBar);
        ExtendedJScrollPane editorScrollPane = new ExtendedJScrollPane(browser);
        editorScrollPane.setPreferredSize(new Dimension(600, 500));
        dialog.getContentPane().add(editorScrollPane);
        dialog.pack();
        dialog.setVisible(true);
        try {
            browser.setPage(url);
        }
        catch (Throwable e) {
            SwingTools.showSimpleErrorMessage("Cannot find '" + url + "'!", e);
        }
    }
}

