/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.AttributePeak;
import com.rapidminer.generator.BasicArithmeticOperationGenerator;
import com.rapidminer.generator.ConstantGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.generator.TrigonometricFunctionGenerator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.BinaryPeakFinder;
import com.rapidminer.tools.math.Complex;
import com.rapidminer.tools.math.FastFourierTransform;
import com.rapidminer.tools.math.Peak;
import com.rapidminer.tools.math.PeakFinder;
import com.rapidminer.tools.math.SpectrumFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinusFactory {
    private static final double MIN_EVIDENCE = 0.2;
    public static final String[] ADAPTION_TYPES = new String[]{"uniformly", "uniformly_without_nu", "gaussian"};
    public static final int UNIFORMLY = 0;
    public static final int UNIFORMLY_WITHOUT_NU = 1;
    public static final int GAUSSIAN = 2;
    private int attributesPerPeak = 3;
    private double epsilon = 0.1;
    private int adaptionType = 0;
    private int maxPeaks = 5;
    private FastFourierTransform fft = null;
    private SpectrumFilter filter = null;
    private PeakFinder peakFinder = null;

    public SinusFactory(int maxPeaks) {
        this.maxPeaks = maxPeaks;
        this.fft = new FastFourierTransform(4);
        this.filter = new SpectrumFilter(0);
        this.peakFinder = new BinaryPeakFinder();
    }

    public void setAdaptionType(int type) {
        this.adaptionType = type;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setAttributePerPeak(int attributesPerPeak) {
        this.attributesPerPeak = attributesPerPeak;
    }

    public List<AttributePeak> getAttributePeaks(ExampleSet exampleSet, Attribute first, Attribute second) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        Complex[] result = this.fft.getFourierTransform(exampleSet, first, second);
        Peak[] spectrum = this.filter.filter(result, exampleSet.size());
        double average = 0.0;
        int k = 0;
        while (k < spectrum.length) {
            average += spectrum[k].getMagnitude();
            ++k;
        }
        average /= (double)spectrum.length;
        List<Peak> peaks = this.peakFinder.getPeaks(spectrum);
        Collections.sort(peaks);
        double inputDeviation = Math.sqrt(exampleSet.getStatistics(second, "variance")) / (exampleSet.getStatistics(second, "maximum") - exampleSet.getStatistics(second, "minimum"));
        Iterator<Peak> p = peaks.iterator();
        double maxEvidence = Double.NaN;
        LinkedList<AttributePeak> attributes = new LinkedList<AttributePeak>();
        int k2 = 0;
        while (k2 < this.maxPeaks) {
            if (p.hasNext()) {
                Peak peak = p.next();
                double evidence = peak.getMagnitude() / average * (1.0 / inputDeviation);
                if (Double.isNaN(maxEvidence)) {
                    maxEvidence = evidence;
                }
                if (evidence > 0.2 * maxEvidence) {
                    attributes.add(new AttributePeak(second, peak.getIndex(), evidence));
                }
            }
            ++k2;
        }
        return attributes;
    }

    public void generateSinusFunctions(ExampleSet exampleSet, List<AttributePeak> attributes, Random random) throws GenerationException {
        if (attributes.size() > 0) {
            Collections.sort(attributes);
            double totalMaxEvidence = attributes.get(0).getEvidence();
            for (AttributePeak ae : attributes) {
                if (!(ae.getEvidence() > 0.2 * totalMaxEvidence)) continue;
                int i = 0;
                while (i < this.attributesPerPeak) {
                    double frequency = ae.getFrequency();
                    switch (this.adaptionType) {
                        case 0: {
                            if (this.attributesPerPeak == 1) break;
                            frequency = (double)i / (double)(this.attributesPerPeak - 1) * 2.0 * this.epsilon * frequency + (frequency - this.epsilon * frequency);
                            break;
                        }
                        case 1: {
                            if (this.attributesPerPeak == 1) break;
                            frequency = (double)i / (double)(this.attributesPerPeak - 1) * 2.0 * this.epsilon + (frequency - this.epsilon);
                            break;
                        }
                        case 2: {
                            frequency = random.nextGaussian() * this.epsilon + frequency;
                        }
                    }
                    List<Attribute> frequencyResult = this.generateAttribute(exampleSet, new ConstantGenerator(frequency));
                    BasicArithmeticOperationGenerator scale = new BasicArithmeticOperationGenerator(2);
                    scale.setArguments(new Attribute[]{frequencyResult.get(0), ae.getAttribute()});
                    List<Attribute> scaleResult = this.generateAttribute(exampleSet, scale);
                    TrigonometricFunctionGenerator sin = new TrigonometricFunctionGenerator(0);
                    sin.setArguments(new Attribute[]{scaleResult.get(0)});
                    List<Attribute> sinResult = this.generateAttribute(exampleSet, sin);
                    for (Attribute attribute : sinResult) {
                        exampleSet.getAttributes().addRegular(attribute);
                    }
                    ++i;
                }
            }
        }
    }

    private List<Attribute> generateAttribute(ExampleSet exampleSet, FeatureGenerator generator) throws GenerationException {
        LinkedList<FeatureGenerator> generators = new LinkedList<FeatureGenerator>();
        generators.add(generator);
        return FeatureGenerator.generateAll(exampleSet.getExampleTable(), generators);
    }
}

