/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantGenerator
extends FeatureGenerator {
    public static final String FUNCTION_NAME = "const";
    private double constant = 1.0;
    private String constantString = "1";

    public ConstantGenerator() {
    }

    public ConstantGenerator(double constant) {
        this.constant = constant;
        this.constantString = String.valueOf(constant);
    }

    @Override
    public void setArguments(Attribute[] args) {
    }

    @Override
    public FeatureGenerator newInstance() {
        return new ConstantGenerator();
    }

    @Override
    public String getFunction() {
        return "const[" + this.constantString + "]";
    }

    @Override
    public void setFunction(String functionName) {
        int leftIndex = functionName.indexOf("[");
        int rightIndex = functionName.indexOf("]");
        if (leftIndex != -1 && rightIndex != -1) {
            this.constantString = functionName.substring(leftIndex + 1, rightIndex);
            this.constant = Double.parseDouble(this.constantString);
        }
    }

    @Override
    public Attribute[] getInputAttributes() {
        return new Attribute[0];
    }

    @Override
    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute ao = AttributeFactory.createAttribute(2, 1, String.valueOf(this.getFunction()) + "()");
        return new Attribute[]{ao};
    }

    @Override
    public List<Attribute[]> getInputCandidates(ExampleSet exampleSet, String[] functions) {
        return new ArrayList<Attribute[]>();
    }

    @Override
    public void generate(DataRow data) throws GenerationException {
        try {
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], this.constant);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a:" + this.getArgument(0), ex);
        }
    }

    @Override
    public String toString() {
        return this.getFunction();
    }
}

