/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.generator.BinaryNumericalGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.tools.LogService;

public class BasicArithmeticOperationGenerator
extends BinaryNumericalGenerator {
    public static final int SUM = 0;
    public static final int DIFFERENCE = 1;
    public static final int PRODUCT = 2;
    public static final int QUOTIENT = 3;
    private static final String[] FUNCTION_NAMES = new String[]{"+", "-", "*", "/"};
    private int mode;

    public BasicArithmeticOperationGenerator(int mode) {
        this.mode = mode;
    }

    public BasicArithmeticOperationGenerator() {
    }

    public boolean isSelfApplicable() {
        return this.mode == 2;
    }

    public boolean isCommutative() {
        return this.mode == 2 || this.mode == 0;
    }

    public FeatureGenerator newInstance() {
        return new BasicArithmeticOperationGenerator(this.mode);
    }

    public double calculateValue(double o1, double o2) {
        double r = 0.0;
        switch (this.mode) {
            case 0: {
                r = o1 + o2;
                break;
            }
            case 1: {
                r = o1 - o2;
                break;
            }
            case 2: {
                r = o1 * o2;
                break;
            }
            case 3: {
                r = o1 / o2;
            }
        }
        return r;
    }

    public void setFunction(String name) {
        int i = 0;
        while (i < FUNCTION_NAMES.length) {
            if (FUNCTION_NAMES[i].equals(name)) {
                this.mode = i;
                return;
            }
            ++i;
        }
        LogService.getGlobal().log("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    public String getFunction() {
        return FUNCTION_NAMES[this.mode];
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.mode == ((BasicArithmeticOperationGenerator)o).mode;
    }

    public int hashCode() {
        return super.hashCode() ^ Integer.valueOf(this.mode).hashCode();
    }
}

