/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.defaults;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.gcube.common.quota.library.quotedefault.QuotaDefault;
import org.gcube.common.quota.library.quotedefault.QuotaDefaultList;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationSystemQuery {
    private static Logger log = LoggerFactory.getLogger(InformationSystemQuery.class);
    private List<QuotaDefault> listQuotaDefault = new ArrayList();

    public InformationSystemQuery() {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'Quota'").addCondition("$resource/Profile/Name/text() eq 'QuotaDefault'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List quotaResources = client.submit((Query)query);
        QuotaDefaultList quotalist = null;
        if (quotaResources.size() > 0) {
            String resource = ((GenericResource)quotaResources.get(0)).profile().bodyAsString();
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{QuotaDefaultList.class});
                quotalist = (QuotaDefaultList)jaxbContext.createUnmarshaller().unmarshal((Reader)new StringReader(resource.toString()));
                this.listQuotaDefault = quotalist.getQuotaDefaultList();
                log.debug("From IS found a quota default:{}", (Object)quotalist.toString());
            }
            catch (Exception e) {
                log.error("--:{}", (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    public List<QuotaDefault> getListQuotaDefault() {
        return this.listQuotaDefault;
    }
}

