/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.check;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.common.quota.check.QuotaCalculateUtil;
import org.gcube.common.quota.check.QuotaUsage;
import org.gcube.common.quota.defaults.InformationSystemQuery;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.gcube.common.quota.util.DiscoveryListUser;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCheck {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
    private String context = null;

    public QuotaCheck(String context) throws NotFoundQuotaExecption {
        this.context = context;
    }

    public void getQuotaCheck() throws SQLException {
        log.info("QuotaCheck - init");
        QuotaCalculateUtil quotaUtility = new QuotaCalculateUtil(this.context);
        InformationSystemQuery informationSystemQuery = new InformationSystemQuery();
        log.debug("QuotaCheck - context:{}, setQuoteDefault:{}", (Object)this.context, (Object)informationSystemQuery.getListQuotaDefault());
        quotaUtility.setQuoteDefault(informationSystemQuery.getListQuotaDefault());
        if (quotaUtility.getQuoteDefault() == null) {
            log.debug("QuotaCheck - No quota default found");
        }
        DiscoveryListUser discoveryListUser = new DiscoveryListUser(this.context);
        log.debug("QuotaCheck - for context:{} , list user:{}", (Object)this.context, (Object)discoveryListUser.getListUser());
        quotaUtility.verifyListUser(discoveryListUser.getListUser());
        log.debug("QuotaCheck - quotaUtility.getUsageToBeVerified():{}", (Object)quotaUtility.getUsageToBeVerified());
        AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
        List quoteChecked = new ArrayList();
        try {
            quoteChecked = apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug("return quota usage:{}", quoteChecked);
        QuotaUsage queryQuotaUsage = new QuotaUsage();
        for (UsageValue usageIndex : quotaUtility.getUsageToBeVerified()) {
            String identifier = usageIndex.getIdentifier();
            Double quotaUsage = usageIndex.getD();
            if (usageIndex.getClz() == QuotaType.STORAGE.getQuotaTypeClass()) {
                log.debug("save quota storage identifier:{},temporalConstraint:{}", (Object)identifier, (Object)usageIndex.getTemporalConstraint());
                QuotaUsageStorageValue usageStorVal = (QuotaUsageStorageValue)usageIndex;
                queryQuotaUsage.insertStorageQuota(identifier, usageStorVal.getdQuota(), quotaUsage, usageIndex.getTemporalConstraint());
            }
            if (usageIndex.getClz() != QuotaType.SERVICE.getQuotaTypeClass()) continue;
            log.debug("save quota service");
        }
        log.debug("verify insert ");
        QuotaStorageStatus quotaStorageStatus = queryQuotaUsage.selectStorageQuota("lucio.lelii", TimeInterval.FOREVER);
        log.debug("verify insert quotaStorageStatus:{}", (Object)quotaStorageStatus.toString());
    }
}

