/**
 * University of Illinois/NCSA Open Source License
 *
 * Copyright (c) 2001,2002 The Board of Trustees of the University of Illinois
 * All rights reserved.
 *
 * Developed by:  Open Archives Initiative Metadata Harvesting Project
 *                University of Illinois at Urbana-Champaign
 *                http://oai.grainger.uiuc.edu/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 *  . Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimers.
 *  . Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimers in the
 *    documentation and/or other materials provided with the distribution.
 *  . Neither the names of Open Archives Initiative Metadata Harvesting
 *    Project, University of Illinois at Urbana-Champaign, nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this Software without specific prior written permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS WITH THE SOFTWARE.
 *
 * DC.Title:          OAIException
 *
 * DC.Contributor:    Yuping Tseng, ytseng1@uiuc.edu, University og Illinois at Urbana-Champaign
 * DC.Contributor:    Tom Habing, thabing@uiuc.edu, University of Illinois at Urbana-Champaign
 *
 * DC.Date.Modified:  4/01/02 3:00p
 *
 * DC:Rights:         University of Illinois/NCSA Open Source License
 *
 * DC.Relation:       For more information see http://oai.grainger.uiuc.edu/
 */

package org.gcube.common;

/**
 * This class implements an exception object that all OAI classes will throw in case of an error. 
 */
public class OAIException extends Exception {

 public OAIException(short code, String msg) {
  super(msg);
  this.code = code;
 }

 /**
  * Exception code
  */
 public short code;

 /**
  * A failed attempt has been made to Refresh an OAIRecord. This could be because the metadataPrefix is not supported or other 
  *  reasons. 
  */
 public static final short FAILED_REFRESH_ERR = 1;

 /**
  * The OAI provider returned an unexpected HTTP status code, such as 400. The only HTTP status codes currently expected are 200 
  *  OK, 30x (redirects), or 503 Unavailable.
  */
 public static final short HTTP_ERR = 2;

 /**
  * This error is currently unused. It would occur if an attempt is made to access a property of an identifier-only 
  *  OAIRecord; however, attempts to do this will currently automatically convert these types of records into complete records. 
  */
 public static final short ID_ONLY_ERR = 3;

 /**
  * The XML response returned by the OAI provider is not valid, usually because it is missing a key element such as 
  *  <responseDate> or <requestURL>. 
  */
 public static final short INVALID_RESPONSE_ERR = 4;
 
 /**
  * An attempt to use a verb parameter value that is not supported by the OAI protocol has been made. 
  */
 public static final short INVALID_VERB_ERR = 5;

 /**
  * A property or method which depends on contacting an OAI Provider site is being accessed without first setting the 
  *  BaseURL property of the OAIRepository. 
  */
 public static final short NO_BASE_URL_ERR = 6;

 /**
  * An attempt has been made to MoveNext past the end of a list of records. 
  */
 public static final short NO_MORE_SETS_ERR = 7;

 /**
  * The Identify request did not return an oai-identifier description, so this property is not available. 
  */
 public static final short NO_OAI_IDENTIFIER_ERR = 8;

 /**
  * An attempt to use an uninitialized OAIResumptionStream has been made. 
  */
 public static final short NOT_INITIALIZED_ERR = 9;

 /**
  * 'value' is not a valid retry-after header
  */
 public static final short RETRY_AFTER_ERR = 10;

 /**
  * In the case of an HTTP 503 status, the maximum number of allowable retries has been exceeded. 
  */
 public static final short RETRY_LIMIT_ERR = 11;

 /**
  * An OAIRecordList contains elements which are not legal according to the OAI protocol. The only legal elements are 
  *  <identifier> or <record>. 
  */
 public static final short UNKNOWN_ELEMENT_ERR = 12;

 /**
  * The XML parser has detected an XML error. If Validation is Strict this will be a well-formedness error, possible an invalid 
  *  Unicode character. If Validation is Very Strict it could also be that the response does not validate against the XML 
  *  Schema. This error should never occur if Validation is Loose.
  */
 public static final short XML_PARSE_ERR = 13;

 /**
  * All the other critical system or network error
  */
 public static final short CRITICAL_ERR = 14;

 /**
  * An attempt to use a feature not spported by OAI 1.x repositories
  */
 public static final short OAI_2_ONLY_ERR = 15;

 /**
  * An OAI error
  */
 public static final short OAI_ERR = 15;
}
