/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.gcube.common.OAIException;
import org.gcube.common.OAIRepository;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAIRecord {
    private List<String> sets = new ArrayList<String>();
    private String strStatus = "";
    private String strIdentifier = "";
    private String strDatestamp = "";
    private String strMetadataPrefix = "";
    private String strMetadata = "";
    private boolean boolIdOnly = true;
    private boolean boolValid = true;
    private Node xmlRecord = null;
    private OAIRepository repo;

    public String getMetadataNamespaceURI() throws OAIException {
        String ret = "";
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)"oai:metadata/*", (Node)this.repo.getNamespaceNode());
            if (node != null) {
                ret = node.getNamespaceURI();
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public String getAboutNamespaceURI() throws OAIException {
        return this.getAboutNamespaceURI(0);
    }

    public String getAboutNamespaceURI(int i) throws OAIException {
        String ret = "";
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("oai:about[" + (i + 1) + "]/*"), (Node)this.repo.getNamespaceNode());
            if (node != null) {
                ret = node.getNamespaceURI();
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    private void priCheckIdOnly() throws OAIException {
        if (this.boolIdOnly) {
            this.refreshRecord();
        }
    }

    public String getDatestamp() throws OAIException {
        if (this.repo.getProtocolMajorVersion() < 2) {
            this.priCheckIdOnly();
        }
        return this.strDatestamp;
    }

    public boolean deleted() {
        return this.strStatus.equals("deleted");
    }

    public boolean isRecordValid() {
        return this.boolValid;
    }

    public String getIdentifier() {
        return this.strIdentifier;
    }

    public String getStatus() {
        return this.strStatus;
    }

    public Node getMetadata() throws OAIException {
        Node ret = null;
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)"oai:metadata/*", (Node)this.repo.getNamespaceNode());
            if (node != null) {
                ret = node.cloneNode(true);
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public int getAboutCount() throws OAIException {
        int ret = 0;
        this.priCheckIdOnly();
        try {
            NodeList list = XPathAPI.selectNodeList((Node)this.xmlRecord, (String)"oai:about/*", (Node)this.repo.getNamespaceNode());
            ret = list.getLength();
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public Node getAbout() throws OAIException {
        return this.getAbout(0);
    }

    public Node getAbout(int i) throws OAIException {
        Node ret = null;
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("oai:about[" + (i + 1) + "]/*"), (Node)this.repo.getNamespaceNode());
            if (node != null) {
                ret = node.cloneNode(true);
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public boolean isIdentifierOnly() {
        return this.boolIdOnly;
    }

    public String getMetadataPrefix() throws OAIException {
        if (this.repo.getProtocolMajorVersion() < 2) {
            this.priCheckIdOnly();
        }
        return this.strMetadataPrefix;
    }

    public Node getRecord() throws OAIException {
        this.priCheckIdOnly();
        return this.xmlRecord.cloneNode(true);
    }

    public void refreshRecord() throws OAIException {
        if (this.strMetadataPrefix != null) {
            if (this.strMetadataPrefix.length() == 0) {
                this.strMetadataPrefix = "oai_dc";
            }
        } else {
            this.strMetadataPrefix = "oai_dc";
        }
        this.refreshRecord(this.strMetadataPrefix);
    }

    public void refreshRecord(String meta) throws OAIException {
        OAIRecord rec = this.repo.getRecord(this.strIdentifier, meta);
        if (rec == null) {
            throw new OAIException(1, "Record failed to refresh, illegal or nonexisting identifier?");
        }
        this.frndSetDatestamp(rec.getDatestamp());
        this.frndSetIdentifier(rec.getIdentifier());
        this.frndSetIdOnly(rec.isIdentifierOnly());
        this.frndSetMetadataPrefix(meta);
        this.frndSetStatus(rec.deleted() ? "deleted" : "");
        this.frndSetRecord(rec.getRecord());
        this.frndSetValid(rec.isRecordValid());
        this.boolIdOnly = false;
    }

    public int getSetSpecCount() throws OAIException {
        int ret = 0;
        try {
            NodeList list = XPathAPI.selectNodeList((Node)this.xmlRecord, (String)"//oai:setSpec", (Node)this.repo.getNamespaceNode());
            ret = list.getLength();
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public String getSetSpec() throws OAIException {
        return this.getSetSpec(0);
    }

    public List<String> getSetSpeList() throws OAIException {
        return this.sets;
    }

    public String getSetSpec(int i) throws OAIException {
        String ret = "";
        if (this.repo.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'setSpec' of header is not supported.");
        }
        if (this.getSetSpecCount() > 0 && i < this.getSetSpecCount()) {
            try {
                Node n = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("//oai:setSpec[" + (i + 1) + "]/text()"), (Node)this.repo.getNamespaceNode());
                if (n != null) {
                    ret = n.getNodeValue();
                }
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
        }
        return ret;
    }

    protected void frndSetIdentifier(String i) {
        this.strIdentifier = i;
    }

    protected void frndSetDatestamp(String d) {
        this.strDatestamp = d;
    }

    protected void frndSetRepository(OAIRepository r) {
        this.repo = r;
    }

    protected void frndSetMetadataPrefix(String m) {
        this.strMetadataPrefix = m;
    }

    protected void frndSetValid(boolean v) {
        this.boolValid = v;
    }

    protected void frndSetIdOnly(boolean b) {
        this.boolIdOnly = b;
    }

    protected void frndSetRecord(Node n) {
        this.xmlRecord = n;
    }

    protected void frndSetStatus(String s) {
        this.strStatus = s;
    }

    protected void addSet(String s) {
        this.sets.add(s);
    }

    public void setMetadataRecord(String s) {
        this.strMetadata = s;
    }

    public String getMetadataRecord() {
        return this.strMetadata;
    }
}

