/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.gcube.common.OAIException;
import org.gcube.common.OAIRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OAIResumptionStream {
    private String strBaseURL;
    private String strVerb;
    private String strParams;
    private String strResumptionToken;
    private String strExpirationDate;
    private Document xml;
    private NodeList nodeList;
    private int iIndex;
    private int iCompleteListSize;
    private int iCursor;
    private int iCount;
    private int iRealCursor;
    private Element namespaceNode;
    private boolean boolInitialized;
    private boolean boolValidResponse;
    private int iResumptionCount;
    private OAIRepository oParent;

    public OAIResumptionStream(OAIRepository repo, String u, String v) throws OAIException {
        this.initialize(repo, u, v, "");
    }

    public OAIResumptionStream(OAIRepository repo, String u, String v, String params) throws OAIException {
        this.initialize(repo, u, v, params);
    }

    private void initialize(OAIRepository repo, String u, String v, String params) throws OAIException {
        this.oParent = repo;
        this.strVerb = v;
        this.strBaseURL = u;
        this.strParams = params;
        this.strResumptionToken = "";
        this.iResumptionCount = 0;
        this.boolInitialized = false;
        this.boolValidResponse = false;
        this.iIndex = 1;
        this.iCount = -1;
        this.iCursor = -1;
        this.iRealCursor = -1;
        this.iCompleteListSize = -1;
        if (!(this.strVerb.equals("ListIdentifiers") || this.strVerb.equals("ListMetadataFormats") || this.strVerb.equals("ListRecords") || this.strVerb.equals("ListSets"))) {
            throw new OAIException(5, "Invalid verb");
        }
        if (this.strBaseURL.length() == 0) {
            throw new OAIException(6, "No baseURL");
        }
        if (params.length() > 0 && params.charAt(0) != '&') {
            params = "&" + params;
        }
        try {
            URL url = new URL(this.strBaseURL + "?verb=" + this.strVerb + params);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http = this.oParent.frndTrySend(http);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            if (this.oParent.getValidation() == 1) {
                docFactory.setValidating(true);
            } else {
                docFactory.setValidating(false);
            }
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            try {
                InputStream is = http.getInputStream();
                this.xml = docBuilder.parse(is);
                this.boolValidResponse = true;
                is.close();
            }
            catch (IllegalArgumentException iae) {
                throw new OAIException(14, iae.getMessage());
            }
            catch (SAXException se) {
                if (this.oParent.getValidation() != 2) {
                    throw new OAIException(13, se.getMessage() + " Try loose validation.");
                }
                try {
                    http.disconnect();
                    url = new URL(this.strBaseURL + "?verb=" + this.strVerb + params);
                    http = (HttpURLConnection)url.openConnection();
                    http = this.oParent.frndTrySend(http);
                    this.xml = docBuilder.parse(this.priCreateDummyResponse(http.getInputStream()));
                }
                catch (SAXException se2) {
                    throw new OAIException(13, se2.getMessage());
                }
            }
            this.namespaceNode = this.xml.createElement(this.strVerb);
            this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI + this.strVerb);
            this.namespaceNode.setAttribute("xmlns:dc", OAIRepository.XMLNS_DC);
            PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
            XPath xpath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolver, 0, null);
            XPathContext xpathSupport = new XPathContext();
            int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)this.xml);
            XObject list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
            Node node = list.nodeset().nextNode();
            if (node == null) {
                this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_2_0);
                prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                xpath = new XPath("/oai:OAI-PMH", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_1_0 + this.strVerb);
                } else {
                    xpath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    NodeList nl = list.nodelist();
                    if (nl.getLength() > 0) {
                        this.oParent.frndSetErrors(nl);
                        throw new OAIException(15, this.oParent.getLastOAIError().getCode() + ": " + this.oParent.getLastOAIError().getReason());
                    }
                }
            }
            xpath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolver, 0, null);
            list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
            this.nodeList = list.nodelist();
            this.boolInitialized = true;
            this.oParent.frndSetNamespaceNode(this.namespaceNode);
            xpath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolver, 0, null);
            node = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver).nodeset().nextNode();
            if (node != null) {
                this.oParent.frndSetRequest(node);
            }
            this.oParent.frndSetResponseDate(this.getResponseDate());
            docFactory = null;
            docBuilder = null;
            url = null;
            prefixResolver = null;
            xpathSupport = null;
            xpath = null;
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        catch (MalformedURLException mue) {
            throw new OAIException(14, mue.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            throw new OAIException(14, fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new OAIException(14, pce.getMessage());
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
    }

    public int getCompleteSize() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        return this.iCompleteListSize;
    }

    public int getResumptionCursor() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        if (this.iCursor == -1) {
            return this.iRealCursor;
        }
        return this.iCursor;
    }

    public String getResumptionExpirationDate() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        return this.strExpirationDate;
    }

    public int getIndex() throws OAIException {
        return this.getResumptionCursor() + this.iIndex - 1;
    }

    public boolean isResponseValid() {
        return this.boolValidResponse;
    }

    public boolean more() throws OAIException {
        boolean ret = false;
        this.priCheckInitialized();
        if (this.strResumptionToken.length() > 0 || this.iIndex <= this.priGetSetCount()) {
            ret = true;
        }
        return ret;
    }

    public void moveNext() throws OAIException {
        this.priCheckInitialized();
        int cnt = this.priGetSetCount();
        if (this.more()) {
            if (this.iIndex <= cnt) {
                ++this.iIndex;
            }
            if (this.iIndex > cnt) {
                this.priResumption();
            }
        } else {
            throw new OAIException(7, "No more sets");
        }
    }

    public String getBaseURL() throws OAIException {
        this.priCheckInitialized();
        return this.strBaseURL;
    }

    public String getResponseDate() throws OAIException {
        String ret = "";
        this.priCheckInitialized();
        NodeList list = this.xml.getElementsByTagName("responseDate");
        if (list.getLength() <= 0) {
            throw new OAIException(4, this.strVerb + " missing responseDate");
        }
        ret = list.item(0).getFirstChild().getNodeValue();
        return ret;
    }

    public String getRequestURL() throws OAIException {
        String ret;
        block12: {
            this.priCheckInitialized();
            ret = "";
            try {
                Node node = XPathAPI.selectSingleNode((Node)this.xml, (String)"//oai:requestURL | //oai:request", (Node)this.namespaceNode);
                if (node != null) {
                    ret = node.getFirstChild().getNodeValue();
                    NamedNodeMap map = node.getAttributes();
                    Node n = map.getNamedItem("verb");
                    if (n != null) {
                        ret = ret + "?verb=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("identifier")) != null) {
                        ret = ret + "&identifier=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("metadataPrefix")) != null) {
                        ret = ret + "&metadataPrefix=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("from")) != null) {
                        ret = ret + "&from=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("until")) != null) {
                        ret = ret + "&until=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("set")) != null) {
                        ret = ret + "&set=" + n.getNodeValue();
                    }
                    if ((n = map.getNamedItem("resumptionToken")) != null) {
                        try {
                            ret = ret + "&resumptionToken=" + URLEncoder.encode(n.getNodeValue(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            ret = ret + "&resumptionToken=" + n.getNodeValue();
                        }
                    }
                    break block12;
                }
                throw new OAIException(4, this.strVerb + " missing requestURL/request");
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
        }
        return ret;
    }

    public Node getItem() throws OAIException {
        this.priCheckInitialized();
        return this.priGetXMLItem(this.iIndex);
    }

    public String getParams() throws OAIException {
        this.priCheckInitialized();
        return this.strParams;
    }

    public OAIRepository getRepository() {
        return this.oParent;
    }

    public String getVerb() throws OAIException {
        this.priCheckInitialized();
        return this.strVerb;
    }

    public void requery() throws OAIException {
        this.priCheckInitialized();
        this.initialize(this.oParent, this.strBaseURL, this.strVerb, this.strParams);
    }

    private void priCheckInitialized() throws OAIException {
        if (!this.boolInitialized) {
            throw new OAIException(9, "Not initialized");
        }
    }

    private Node priGetXMLItem(int i) {
        if (this.nodeList != null && i <= this.nodeList.getLength()) {
            return this.nodeList.item(i - 1);
        }
        return null;
    }

    private int priGetSetCount() {
        if (this.iCount >= 0) {
            return this.iCount;
        }
        this.iCount = this.nodeList.getLength();
        return this.iCount;
    }

    public int getResponseSize() throws OAIException {
        this.priCheckInitialized();
        return this.priGetSetCount();
    }

    private String priGetResumptionToken() throws OAIException {
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xml, (String)("//oai:" + this.strVerb + "/oai:resumptionToken/text()"), (Node)this.namespaceNode);
            if (node != null) {
                this.strResumptionToken = node.getNodeValue().trim();
                NamedNodeMap map = node.getParentNode().getAttributes();
                Node n = map.getNamedItem("expirationDate");
                this.strExpirationDate = n != null ? n.getNodeValue() : "";
                n = map.getNamedItem("completeListSize");
                if (n != null) {
                    try {
                        this.iCompleteListSize = Integer.parseInt(n.getNodeValue());
                    }
                    catch (NumberFormatException ne) {
                        this.iCompleteListSize = -1;
                    }
                } else {
                    this.iCompleteListSize = -1;
                }
                if ((n = map.getNamedItem("cursor")) != null) {
                    try {
                        this.iCursor = Integer.parseInt(n.getNodeValue());
                    }
                    catch (NumberFormatException ne) {
                        this.iCursor = -1;
                    }
                } else {
                    this.iCursor = -1;
                }
            } else {
                this.strResumptionToken = "";
                this.strExpirationDate = "";
                this.iCompleteListSize = -1;
                this.iCursor = -1;
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        if (this.strResumptionToken.length() == 0 && this.iCompleteListSize == -1) {
            this.iCompleteListSize = this.iCursor == -1 ? this.priGetSetCount() + this.iRealCursor : this.priGetSetCount() + this.iCursor;
        }
        return this.strResumptionToken;
    }

    private String priGetMainNodeName() throws OAIException {
        String ret;
        if (this.strVerb.equals("ListSets")) {
            ret = "set";
        } else if (this.strVerb.equals("ListIdentifiers")) {
            ret = this.oParent.getProtocolMajorVersion() < 2 ? "identifier" : "header";
        } else if (this.strVerb.equals("ListMetadataFormats")) {
            ret = "metadataFormat";
        } else if (this.strVerb.equals("ListRecords")) {
            ret = "record";
        } else {
            throw new OAIException(5, "Invalid verb");
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputSource priCreateDummyResponse(InputStream x) throws OAIException {
        String ret;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (this.oParent.getProtocolMajorVersion() < 2) {
            if (this.strVerb.equals("ListSets")) {
                ret = "<ListSets xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListSets' \n";
                ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListSets ";
                ret = ret + "http://www.openarchives.org/OAI/1.1/OAI_ListSets.xsd'> \n";
                ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
                ret = ret + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                ret = ret + "<set> \n";
                ret = ret + "<setSpec>junk:set" + this.iResumptionCount + "</setSpec> \n";
                ret = ret + "<setName><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></setName> \n";
                ret = ret + "</set> \n";
                ret = ret + this.priTryToGetResumptionToken(x) + "\n";
                ret = ret + "</ListSets>\n";
            } else if (this.strVerb.equals("ListIdentifiers")) {
                ret = "<ListIdentifiers xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers' \n";
                ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers ";
                ret = ret + "http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers.xsd'> \n";
                ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
                ret = ret + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                ret = ret + "<identifier><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></identifier> \n";
                ret = ret + this.priTryToGetResumptionToken(x) + "\n";
                ret = ret + "</ListIdentifiers>\n";
            } else if (this.strVerb.equals("ListMetadataFormats")) {
                ret = "<ListMetadataFormats xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats' \n";
                ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats ";
                ret = ret + "http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats.xsd'> \n";
                ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
                ret = ret + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                ret = ret + "<metadataFormat> \n";
                ret = ret + "<metadataPrefix>junk_metadataPrefix" + this.iResumptionCount + "</metadataPrefix> \n";
                ret = ret + "<schema><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></schema> \n";
                ret = ret + "</metadataFormat> \n";
                ret = ret + this.priTryToGetResumptionToken(x) + "\n";
                ret = ret + "</ListMetadataFormats>\n";
            } else {
                if (!this.strVerb.equals("ListRecords")) throw new OAIException(5, "Invalid verb");
                ret = "<ListRecords \n";
                ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                ret = ret + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListRecords' \n";
                ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListRecords ";
                ret = ret + "http://www.openarchives.org/OAI/1.1/OAI_ListRecords.xsd'>\n";
                ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate>\n";
                ret = ret + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL>";
                ret = ret + "<record>\n";
                ret = ret + "<header>\n";
                ret = this.oParent.usesOAIIdentifier() ? ret + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : ret + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
                ret = ret + "<datestamp>" + formatter.format(new Date()) + "</datestamp>\n";
                ret = ret + "</header>\n";
                ret = ret + "<about>\n";
                ret = ret + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></junk:junk>\n";
                ret = ret + "</about>\n";
                ret = ret + "</record>\n";
                ret = ret + this.priTryToGetResumptionToken(x) + "\n";
                ret = ret + "</ListRecords>\n";
            }
        } else if (this.strVerb.equals("ListSets")) {
            ret = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            ret = ret + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
            ret = ret + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            ret = ret + "<ListSets> \n";
            ret = ret + "<set> \n";
            ret = ret + "<setSpec>junk:set" + this.iResumptionCount + "</setSpec> \n";
            ret = ret + "<setName>INVALID SET</setName> \n";
            ret = ret + "<setDescription><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></setDescription> \n";
            ret = ret + "</set> \n";
            ret = ret + this.priTryToGetResumptionToken(x) + "\n";
            ret = ret + "</ListSets>\n";
            ret = ret + "</OAI-PMH>\n";
        } else if (this.strVerb.equals("ListIdentifiers")) {
            ret = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            ret = ret + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
            ret = ret + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            ret = ret + "<ListIdentifiers>\n";
            ret = ret + "<header>\n";
            ret = this.oParent.usesOAIIdentifier() ? ret + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : ret + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
            ret = ret + "<datestamp>" + formatter.format(new Date()) + "</datestamp>\n";
            ret = ret + "<setSpec><![CDATA[" + this.oParent.frndMyEncode(x) + "]]>\n";
            ret = ret + "</header>\n";
            ret = ret + this.priTryToGetResumptionToken(x) + "\n";
            ret = ret + "</ListIdentifiers>\n";
            ret = ret + "</OAI-PMH>\n";
        } else if (this.strVerb.equals("ListMetadataFormats")) {
            ret = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            ret = ret + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
            ret = ret + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            ret = ret + "<metadataFormat> \n";
            ret = ret + "<metadataPrefix>junk_metadataPrefix" + this.iResumptionCount + "</metadataPrefix> \n";
            ret = ret + "<schema><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></schema> \n";
            ret = ret + "</metadataFormat> \n";
            ret = ret + this.priTryToGetResumptionToken(x) + "\n";
            ret = ret + "</ListMetadataFormats>\n";
            ret = ret + "</OAI-PMH>\n";
        } else {
            if (!this.strVerb.equals("ListRecords")) throw new OAIException(5, "Invalid verb");
            ret = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            ret = ret + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
            ret = ret + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            ret = ret + "<record>\n";
            ret = ret + "<header>\n";
            ret = this.oParent.usesOAIIdentifier() ? ret + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : ret + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
            ret = ret + "<datestamp>" + formatter.format(new Date()) + "</datestamp>\n";
            ret = ret + "</header>\n";
            ret = ret + "<about>\n";
            ret = ret + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.oParent.frndMyEncode(x) + "]]></junk:junk>\n";
            ret = ret + "</about>\n";
            ret = ret + "</record>\n";
            ret = ret + this.priTryToGetResumptionToken(x) + "\n";
            ret = ret + "</ListRecords>\n";
            ret = ret + "</OAI-PMH>\n";
        }
        StringReader sr = new StringReader(ret);
        return new InputSource(sr);
    }

    private String priTryToGetResumptionToken(InputStream x) throws OAIException {
        String ret = "";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(x, "UTF-8"));
            String tmp = "";
            int startIdx = -1;
            int endIdx = -1;
            while ((tmp = br.readLine()) != null) {
                if (startIdx < 0 && (endIdx = (ret = tmp.substring((startIdx = tmp.indexOf("<resumptionToken")) + 17)).indexOf("</resumptionToken")) > 0) {
                    ret = ret.substring(0, endIdx);
                } else {
                    if (startIdx <= 0 || (endIdx = (ret = ret + tmp).indexOf("</resumptionToken")) <= 0) continue;
                    ret = ret.substring(0, endIdx);
                }
                break;
            }
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
        return ret;
    }

    private String priXMLEncode(String s) {
        String ret = s;
        int idx = 0;
        while ((idx = ret.indexOf(38, idx)) >= 0) {
            ret = ret.substring(0, idx) + "&amp;" + ret.substring(idx + 1);
            idx += 4;
        }
        return ret;
    }

    private void priResumption() throws OAIException {
        String rt = this.priGetResumptionToken();
        if (rt.length() == 0) {
            return;
        }
        int prevCount = this.priGetSetCount();
        this.iCount = -1;
        ++this.iResumptionCount;
        try {
            URL url = new URL(this.strBaseURL + "?verb=" + this.strVerb + "&resumptionToken=" + URLEncoder.encode(rt, "UTF-8"));
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http = this.oParent.frndTrySend(http);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            if (this.oParent.getValidation() == 1) {
                docFactory.setValidating(true);
            } else {
                docFactory.setValidating(false);
            }
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            try {
                this.xml = docBuilder.parse(http.getInputStream());
                this.boolValidResponse = true;
            }
            catch (IllegalArgumentException iae) {
                throw new OAIException(14, iae.getMessage());
            }
            catch (SAXException se) {
                if (this.oParent.getValidation() != 2) {
                    throw new OAIException(13, se.getMessage() + " Try loose validation.");
                }
                try {
                    http.disconnect();
                    url = new URL(this.strBaseURL + "?verb=" + this.strVerb + "&resumptionToken=" + URLEncoder.encode(rt, "UTF-8"));
                    http = (HttpURLConnection)url.openConnection();
                    http = this.oParent.frndTrySend(http);
                    this.xml = docBuilder.parse(this.priCreateDummyResponse(http.getInputStream()));
                }
                catch (SAXException se2) {
                    throw new OAIException(13, se2.getMessage());
                }
            }
            try {
                this.namespaceNode = this.xml.createElement(this.strVerb);
                this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI + this.strVerb);
                this.namespaceNode.setAttribute("xmlns:dc", OAIRepository.XMLNS_DC);
                PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                XPath xpath = new XPath("/oai:" + this.strVerb, null, (PrefixResolver)prefixResolver, 0, null);
                XPathContext xpathSupport = new XPathContext();
                int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)this.xml);
                XObject list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                Node node = list.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_2_0);
                    prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                    xpath = new XPath("/oai:OAI-PMH", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node == null) {
                        this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_1_0 + this.strVerb);
                    } else {
                        xpath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolver, 0, null);
                        list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                        NodeList nl = list.nodelist();
                        if (nl.getLength() > 0) {
                            this.oParent.frndSetErrors(nl);
                            throw new OAIException(15, this.oParent.getLastOAIError().getCode() + ": " + this.oParent.getLastOAIError().getReason());
                        }
                    }
                }
                xpath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                this.nodeList = list.nodelist();
                this.oParent.frndSetNamespaceNode(this.namespaceNode);
                xpath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolver, 0, null);
                node = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver).nodeset().nextNode();
                if (node != null) {
                    this.oParent.frndSetRequest(node);
                }
                this.oParent.frndSetResponseDate(this.getResponseDate());
                this.iRealCursor += prevCount;
                prefixResolver = null;
                xpathSupport = null;
                xpath = null;
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
            catch (IllegalArgumentException iae) {
                throw new OAIException(14, iae.getMessage());
            }
            docFactory = null;
            docBuilder = null;
            url = null;
        }
        catch (MalformedURLException mue) {
            throw new OAIException(14, mue.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            throw new OAIException(14, ex.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            throw new OAIException(14, fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new OAIException(14, pce.getMessage());
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
        this.iIndex = 1;
    }

    public void close() {
    }
}

