/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.metadataprofilediscovery.reader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.metadataprofilediscovery.jaxb.NamespaceCategories;
import org.gcube.common.metadataprofilediscovery.reader.MetadataProfileNotFoundException;
import org.gcube.common.metadataprofilediscovery.reader.QueryForResourceUtil;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class NamespaceCategoryReader {
    private static Logger logger = LoggerFactory.getLogger(NamespaceCategoryReader.class);
    private static final String GENERIC_RESOURCE_NAMESPACES_NAME = "Namespaces Catalogue Categories";
    private static final String GENERIC_RESOURCE_NAMESPACES_SECONDARY_TYPE = "DataCatalogueNamespace";
    private ScopeBean scope;
    private NamespaceCategories namespaces;

    public NamespaceCategoryReader(ScopeBean scope) throws Exception {
        this.scope = scope;
        this.readNamespaceCategory();
    }

    private void readNamespaceCategory() throws Exception {
        logger.trace("Getting Namespace Category");
        if (this.scope == null) {
            throw new Exception("Scope is null");
        }
        String scopeString = this.scope.toString();
        logger.trace("read scope: " + scopeString);
        this.namespaces = new NamespaceCategories();
        try {
            logger.info("Using scope from ScopeProvider: " + scopeString);
            String queryString = QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryTypeAndName(GENERIC_RESOURCE_NAMESPACES_NAME, GENERIC_RESOURCE_NAMESPACES_SECONDARY_TYPE);
            logger.trace("queryString: " + queryString);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            List appProfile = client.submit((Query)q);
            if (appProfile == null || appProfile.size() == 0) {
                throw new MetadataProfileNotFoundException("Your resource is not registered in the infrastructure, the scope is " + scopeString);
            }
            String theResource = null;
            try {
                theResource = (String)appProfile.get(0);
                logger.debug("Resource (Namespaces Catalogue Categories) found");
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element node = docBuilder.parse(new InputSource(new StringReader(theResource))).getDocumentElement();
                XPathHelper helper = new XPathHelper((Node)node);
                logger.debug("Unmarshalling it..");
                this.readNamespaceCategoryFromResource(helper);
            }
            catch (Exception e) {
                logger.error("Error while parsing Resource " + theResource + " from the infrastructure, the scope is " + scopeString, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch resource with name Namespaces Catalogue Categories and secondary type DataCatalogueNamespace from the infrastructure, the scope is " + scopeString, (Throwable)e);
            throw new Exception("Error while trying to fetch resource with name Namespaces Catalogue Categories and secondary type DataCatalogueNamespace from the infrastructure, the scope is " + scopeString, e);
        }
    }

    private void readNamespaceCategoryFromResource(XPathHelper helper) throws Exception {
        try {
            List namespaceSources = helper.evaluate("/Resource/Profile/Body/namespaces");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NamespaceCategories.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            if (namespaceSources == null || namespaceSources.size() == 0) {
                throw new Exception("Resource does not contain <namespaces> <namespace>...</namespace> </namespaces> in the body");
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(((String)namespaceSources.get(0)).getBytes());
            this.namespaces = (NamespaceCategories)jaxbUnmarshaller.unmarshal((InputStream)stream);
        }
        catch (Exception e) {
            String error = "An error occurred in readNamespaceCategoryFromResource " + e.getMessage();
            logger.error("An error occurred in readNamespaceCategoryFromResource ", (Throwable)e);
            throw new Exception(error);
        }
    }

    public NamespaceCategories getNamespaces() {
        return this.namespaces;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NamespaceCategoryReader [scope=");
        builder.append(this.scope);
        builder.append(", namespaces=");
        builder.append(this.namespaces);
        builder.append("]");
        return builder.toString();
    }
}

