/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.examples;

import java.io.File;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.util.Util;

public class ExamplesUtil {
    public static final String EXAMPLES_PERSISTENCE_ROOT = System.getProperty("java.io.tmpdir") + File.separator + "home_library_examples";

    public static Workspace createWorkspace() throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        return ExamplesUtil.createWorkspace("/test/testscope");
    }

    public static Workspace createWorkspace(String scope) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        return ExamplesUtil.createWorkspace(scope, "user.test");
    }

    public static Workspace createWorkspace(String scope, String user) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManagerFactory factory = ExamplesUtil.getHomeManagerFactory();
        return ExamplesUtil.createWorkspace(factory, user);
    }

    public static Home createHome(String user) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManagerFactory factory = ExamplesUtil.getHomeManagerFactory();
        return ExamplesUtil.createHome(factory, user);
    }

    public static Workspace createWorkspace(HomeManagerFactory factory, String user) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        Home home = ExamplesUtil.createHome(factory, user);
        return home.getWorkspace();
    }

    public static Home createHome(HomeManagerFactory factory, String user) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManager manager = factory.getHomeManager();
        User testUser = manager.getUser(user);
        Home home = manager.getHome(testUser);
        return home;
    }

    public static HomeManagerFactory getHomeManagerFactory(String persistenceRoot) throws InternalErrorException {
        return HomeLibrary.getHomeManagerFactory((String)persistenceRoot);
    }

    public static HomeManagerFactory getHomeManagerFactory() throws InternalErrorException {
        return ExamplesUtil.getHomeManagerFactory(false);
    }

    public static HomeManagerFactory getHomeManagerFactory(boolean clean) throws InternalErrorException {
        File homeLibraryExampleDir = new File(EXAMPLES_PERSISTENCE_ROOT);
        if (clean && homeLibraryExampleDir.exists()) {
            Util.cleanDir((File)homeLibraryExampleDir);
        }
        homeLibraryExampleDir.mkdir();
        return ExamplesUtil.getHomeManagerFactory(EXAMPLES_PERSISTENCE_ROOT);
    }
}

