/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.performance.tool;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gcube.common.homelibrary.performance.tool.MeasurementChannel;
import org.gcube.common.homelibrary.performance.tool.MeasurementData;
import org.gcube.common.homelibrary.performance.tool.MeasurementSession;

public class MeasurementCSVGenerator {
    protected static final String DELIMITER = ",";

    public static void main(String[] args) {
    }

    public static void writeCSV(MeasurementSession session, String fileName) throws IOException {
        FileOutputStream os = new FileOutputStream(fileName);
        StringBuilder header = new StringBuilder();
        for (Long value : session.getValues()) {
            header.append(DELIMITER + String.valueOf(value));
        }
        header.append("\n");
        ((OutputStream)os).write(header.toString().getBytes());
        os.flush();
        for (MeasurementChannel channel : session.getChannels()) {
            StringBuilder row = new StringBuilder(channel.getName());
            for (MeasurementData data : channel.getData()) {
                row.append(DELIMITER + String.valueOf(data.getTime()));
            }
            row.append("\n");
            ((OutputStream)os).write(row.toString().getBytes());
            os.flush();
        }
        ((OutputStream)os).close();
    }
}

