/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.consistency.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.homelibrary.consistency.statistics.HomeCheckStatistics;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;

public class CheckStatistics {
    protected int checkedScopes = 0;
    protected int checkedUsers = 0;
    protected Map<String, HomeCheckStatistics> homesStatistics = new LinkedHashMap<String, HomeCheckStatistics>();
    protected int checkedItems = 0;
    protected int errors = 0;
    protected int folders = 0;
    protected Map<FolderItemType, Integer> folderItemTypesCount = new LinkedHashMap<FolderItemType, Integer>();

    public void addHomeStatistics(String scope, HomeCheckStatistics homeCheckStatistics) {
        ++this.checkedScopes;
        this.checkedUsers += homeCheckStatistics.getCheckedUsers();
        this.homesStatistics.put(scope, homeCheckStatistics);
        this.checkedItems += homeCheckStatistics.getCheckedItems();
        this.errors += homeCheckStatistics.getErrors();
        this.folders += homeCheckStatistics.getFolders();
        for (Map.Entry<FolderItemType, Integer> entry : homeCheckStatistics.getFolderItemTypesCount().entrySet()) {
            if (!this.folderItemTypesCount.containsKey(entry.getKey())) {
                this.folderItemTypesCount.put(entry.getKey(), entry.getValue());
                continue;
            }
            int count = this.folderItemTypesCount.get(entry.getKey());
            this.folderItemTypesCount.put(entry.getKey(), count += entry.getValue().intValue());
        }
    }

    public int getCheckedScopes() {
        return this.checkedScopes;
    }

    public int getCheckedUsers() {
        return this.checkedUsers;
    }

    public Map<String, HomeCheckStatistics> getHomesStatistics() {
        return this.homesStatistics;
    }

    public int getCheckedItems() {
        return this.checkedItems;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFolders() {
        return this.folders;
    }

    public Map<FolderItemType, Integer> getFolderItemTypesCount() {
        return this.folderItemTypesCount;
    }
}

