/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.testdata.TwinDataManager;
import org.gcube.common.homelibrary.testdata.data.DocMetadata;
import org.gcube.common.homelibrary.testdata.data.ImageDocumentData;

public class ImageDataManager
extends TwinDataManager<ImageDocumentData, ExternalImage, ImageDocument> {
    public static final String DATA_FILE = "images.xml";

    public ImageDataManager() {
        super(DATA_FILE);
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("image", ImageDocumentData.class);
        this.xstream.alias("images", LinkedList.class);
        this.xstream.alias("metadata", DocMetadata.class);
    }

    @Override
    protected ImageDocument createDocument(WorkspaceFolder destinationFolder, String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        return destinationFolder.createImageDocumentItem(name, description, oid, mimeType, data, metadata, annotations, collectionName);
    }

    @Override
    protected ExternalImage createExternal(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream data) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        return destinationFolder.createExternalImageItem(name, description, mimeType, data);
    }
}

