/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.common.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.common.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestCreateDocumentMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestCreateDocumentMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test
    public final void testCreateDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolderDocument", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        Document document = this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        UnitTestUtil.testDocumentCreation(document, (WorkspaceItem)folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = document.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)document.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)document.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateDocumentDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder22", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder23", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "Document";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullAnnotationArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder24", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullCollectionNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder25", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder26", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = null;
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullDestinationFolderArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullImageDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder27", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullMetadataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder28", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder29", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateDocumentNullOidArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder30", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateDocumentWrongDestinationFolderIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateDocumentWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder31", "A test folder");
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.ownerWorkspace.createImageDocument("testItem", "An item description", UnitTestUtil.getID(), expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, imageDocument.getId());
    }

    @Test
    public final void testCreateImageDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder32", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        UnitTestUtil.testDocumentCreation((Document)imageDocument, (WorkspaceItem)folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = imageDocument.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.IMAGE_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)imageDocument.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)imageDocument.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreateImageDocumentDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder33", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder34", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "ImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullAnnotationArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder35", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullCollectionNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder36", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder37", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = null;
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullDestinationFolderArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullImageDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder38", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullMetadataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder39", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder40", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateImageDocumentNullOidArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder41", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateImageDocumentWrongDestinationFolderIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreateImageDocumentWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder42", "A test folder");
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.ownerWorkspace.createImageDocument("testItem", "An item description", UnitTestUtil.getID(), expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, imageDocument.getId());
    }

    @Test
    public final void testCreatePDFDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder43", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        PDFDocument pdfDocument = this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        UnitTestUtil.testDocumentCreation((Document)pdfDocument, (WorkspaceItem)folder, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = pdfDocument.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.PDF_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)pdfDocument.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)pdfDocument.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCreatePDFDocumentDuplicateFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder44", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder45", "A test folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "PDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullAnnotationArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder46", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        Map expectedAnnotation = null;
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullCollectionNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder47", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = null;
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullDescriptionArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder48", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = null;
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullDestinationFolderArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullMetadataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder49", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        Map expectedMetadata = null;
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder50", "A test folder");
        String expectedName = null;
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullOidArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder51", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = null;
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreatePDFDocumentNullPDFDataArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder52", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, null, expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreatePDFDocumentWrongDestinationFolderIdArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, "");
    }

    @Test(expected=WrongDestinationException.class)
    public final void testCreatePDFDocumentWrongDestinationTypeFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WorkspaceFolderNotFoundException, WrongDestinationException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder53", "A test folder");
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = UnitTestUtil.getID();
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        PDFDocument PDFDocument2 = this.ownerWorkspace.createPDFDocument("testItem", "An item description", UnitTestUtil.getID(), expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, folder.getId());
        this.ownerWorkspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, PDFDocument2.getId());
    }
}

