/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileCleaner;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.util.zip.ExtractAllFiles;
import org.gcube.common.homelibrary.util.zip.ZipFileModelExtractor;
import org.gcube.common.homelibrary.util.zip.ZipModelToWorkspaceCreator;
import org.gcube.common.homelibrary.util.zip.ZipModelVisitor;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipUtil {
    protected static final Logger logger = LoggerFactory.getLogger((String)HomeLibrary.class.getPackage().getName());

    public static void unzip(WorkspaceFolder destinationFolder, InputStream is, String zipName) throws IOException {
        logger.trace("unzip destinationWorkspace: " + destinationFolder + ", zipName: " + zipName);
        logger.trace("Extracting zip model from zip file.");
        ZipFileModelExtractor zme = new ZipFileModelExtractor(is);
        List<ZipItem> items = zme.getModel();
        logger.trace("Zip Model:");
        ZipModelVisitor visitor = new ZipModelVisitor();
        visitor.visit(items);
        logger.trace("Creating the items");
        ZipModelToWorkspaceCreator creator = new ZipModelToWorkspaceCreator();
        creator.create(destinationFolder, items);
    }

    public static void unzip(WorkspaceFolder destinationFolder, String zipPath) throws IOException {
        logger.trace("unzip destinationWorkspace: " + destinationFolder + ", zipPath: " + zipPath);
        logger.trace("Extracting zip model from zip file.");
        ExtractAllFiles zme = new ExtractAllFiles(zipPath);
        List<ZipItem> items = zme.getModel();
        logger.trace("Zip Model:");
        ZipModelVisitor visitor = new ZipModelVisitor();
        visitor.visit(items);
        logger.trace("Creating the items");
        ZipModelToWorkspaceCreator creator = new ZipModelToWorkspaceCreator();
        creator.create(destinationFolder, items);
    }

    public static void unzip(InputStream is, OutputStream os) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            os.close();
            return;
        }
        throw new Exception("No file entry found");
    }

    public static InputStream unzipToTmp(InputStream is) throws Exception {
        ZipEntry entry;
        File tmpFile = File.createTempFile("unzippedts", "tmp");
        FileOutputStream os = new FileOutputStream(tmpFile);
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)zis, (OutputStream)os);
            zis.closeEntry();
            zis.close();
            ((OutputStream)os).close();
            FileInputStream tmpis = new FileInputStream(tmpFile);
            FileCleaner.track((File)tmpFile, (Object)tmpis);
            return tmpis;
        }
        throw new Exception("No file entry found");
    }
}

