/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.util;

import com.itextpdf.text.pdf.PdfReader;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.MultipleOutputStream;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceItemUtil {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceItemUtil.class);
    private static final int THUMB_MAX_DIM = 400;
    public static final String NUMBER_OF_PAGES = "xmpTPg:NPages";
    public static final String PRODUCER = "producer";
    public static final String VERSION = "version";
    public static final String AUTHOR = "Author";
    public static final String TITLE = "dc:title";
    public static final Object WIDTH = "width";
    public static final Object HEIGHT = "height";

    public static ImagePlus getImgePlus(String pathOrURL) throws IOException {
        System.setProperty("java.awt.headless", "true");
        ImagePlus img = null;
        try {
            img = new ImagePlus(pathOrURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return img;
    }

    public static int[] getThumbnailDimension(int original_width, int original_height) {
        int new_width = 0;
        int new_height = 0;
        if (original_width < 400 && original_height < 400) {
            new_width = original_width;
            new_height = original_height;
        }
        if (original_width > 400) {
            new_width = 400;
            new_height = new_width * original_height / original_width;
        }
        if (original_width < 400) {
            new_width = 400;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > 400) {
            new_height = 400;
            new_width = new_height * original_width / original_height;
        }
        if (new_width > 400) {
            new_width = 400;
            new_height = new_width * original_height / original_width;
        }
        int[] dimension = new int[]{new_width, new_height};
        return dimension;
    }

    public static InputStream getThumbnailAsPng(ImagePlus img, int[] thumbSize) throws IOException {
        return WorkspaceItemUtil.getThumbnailAsPng(img, thumbSize[0], thumbSize[1]);
    }

    public static InputStream getThumbnailAsPng(ImagePlus img, int thumbWidth, int thumbHeight) throws IOException {
        FileInputStream stream = null;
        ImageProcessor processor = img.getProcessor();
        try {
            Image thumb = processor.resize(thumbWidth, thumbHeight).createImage();
            thumb = thumb.getScaledInstance(thumbWidth, thumbHeight, 4);
            FileSaver fs = new FileSaver(new ImagePlus("", thumb));
            File tmpThumbFile = File.createTempFile("THUMB", "TMP");
            tmpThumbFile.deleteOnExit();
            fs.saveAsPng(tmpThumbFile.getAbsolutePath());
            stream = new FileInputStream(tmpThumbFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    public static HashMap<String, String> getPDFInfo(final InputStream is) {
        final HashMap<String, String> info = new HashMap<String, String>();
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    PdfReader reader = new PdfReader(is);
                    info.put(WorkspaceItemUtil.NUMBER_OF_PAGES, String.valueOf(reader.getNumberOfPages()));
                    info.put(WorkspaceItemUtil.VERSION, String.valueOf(reader.getPdfVersion()));
                    info.putAll(reader.getInfo());
                }
                catch (Exception e) {
                    logger.error("PDF info has not been retrieved", (Throwable)e);
                }
            }
        };
        th.start();
        try {
            th.join();
        }
        catch (InterruptedException e) {
            logger.error("InternalError in getPDFInfo ", (Throwable)e);
        }
        WorkspaceItemUtil.checkPDFInfo(info);
        return info;
    }

    private static void checkPDFInfo(HashMap<String, String> info) {
        if (!info.containsKey(AUTHOR)) {
            info.put(AUTHOR, "n/a");
        }
        if (!info.containsKey(PRODUCER)) {
            info.put(PRODUCER, "n/a");
        }
        if (!info.containsKey(TITLE)) {
            info.put(TITLE, "n/a");
        }
        if (!info.containsKey(VERSION)) {
            info.put(VERSION, "n/a");
        }
        if (info.containsKey(NUMBER_OF_PAGES)) {
            try {
                int pages = Integer.parseInt(info.get(NUMBER_OF_PAGES));
                info.put(NUMBER_OF_PAGES, String.valueOf(pages));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            info.put(NUMBER_OF_PAGES, "0");
        }
    }

    public static MetaInfo getMetadataInfo(InputStream stream, GCUBEStorage storage, String remotePath, String filenameWithExtension, String mimeType, long size) throws RemoteBackendException, IOException, InternalErrorException {
        if (mimeType != null && !mimeType.isEmpty()) {
            MetaInfo metadataInfo = new MetaInfo();
            metadataInfo.setMimeType(mimeType);
            metadataInfo.setSize((int)size);
            logger.debug("Save file to Storage in remotepath " + remotePath);
            WorkspaceItemUtil.saveToStorage(stream, storage, remotePath, metadataInfo, filenameWithExtension);
            logger.debug("Set Mimetype for file " + filenameWithExtension + " to " + mimeType);
            WorkspaceItemUtil.updateMimeTypeIntoStorage(storage, metadataInfo, remotePath, filenameWithExtension);
            return metadataInfo;
        }
        return WorkspaceItemUtil.getMetadataInfo(stream, storage, remotePath, filenameWithExtension);
    }

    private static void updateMimeTypeIntoStorage(GCUBEStorage storage, MetaInfo metadataInfo, String remotePath, String filenameWithExtension) {
        long start = System.currentTimeMillis();
        if (metadataInfo.getStorageId() != null && metadataInfo.getMimeType() != null) {
            logger.debug("Update mimetype metadata for remotepath: " + remotePath + " to " + metadataInfo.getMimeType());
            storage.setMetaInfo("mimetype", metadataInfo.getMimeType(), remotePath);
        }
        logger.debug("UPDATE Mimetype into storage for file " + filenameWithExtension + " in milliseconds: " + (System.currentTimeMillis() - start));
    }

    private static void saveToStorage(InputStream is, GCUBEStorage storage, String remotePath, MetaInfo metadataInfo, String filenameWithExtension) throws IOException {
        long start = System.currentTimeMillis();
        String url = null;
        int availableSize = is.available();
        try {
            url = storage.putStream(is, remotePath);
            metadataInfo.setStorageId(url);
            metadataInfo.setRemotePath(remotePath);
            logger.debug(filenameWithExtension + " saved to " + remotePath + " - GCUBEStorage URL : " + url);
            long start00 = System.currentTimeMillis();
            if (metadataInfo.getSize() <= 0) {
                long size = storage.getRemoteFileSize(remotePath);
                if (size < (long)availableSize) {
                    logger.error("size < available for file " + remotePath);
                } else {
                    metadataInfo.setSize((int)size);
                }
            }
        }
        catch (RemoteBackendException e) {
            logger.error(remotePath + " remote path not present " + (Object)((Object)e));
            throw new RemoteBackendException(e.getMessage());
        }
    }

    public static MetaInfo getMetadataInfo(InputStream stream, final GCUBEStorage storage, final String remotePath, final String filenameWithExtension) throws RemoteBackendException, IOException, InternalErrorException {
        final MultipleOutputStream mos = new MultipleOutputStream(stream);
        final MetaInfo metadataInfo = new MetaInfo();
        Thread t1 = new Thread(){

            @Override
            public void run() {
                logger.debug("Save file to Storage in remotepath " + remotePath);
                try (InputStream is = mos.getS1();){
                    WorkspaceItemUtil.saveToStorage(is, storage, remotePath, metadataInfo, filenameWithExtension);
                }
                catch (IOException e) {
                    throw new RemoteBackendException(e.getMessage());
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                logger.debug("Mimetype detect for file " + filenameWithExtension);
                long start = System.currentTimeMillis();
                try (InputStream is = mos.getS2();){
                    String mimetype = MimeTypeUtil.getMimeType((String)filenameWithExtension, (InputStream)is);
                    logger.debug(filenameWithExtension + " mimetyepe: " + mimetype);
                    metadataInfo.setMimeType(mimetype);
                }
                catch (IOException e) {
                    throw new RemoteBackendException(e.getMessage());
                }
                logger.debug("Mimetype detected for file " + filenameWithExtension + " in milliseconds: " + (System.currentTimeMillis() - start));
            }
        };
        t1.start();
        t2.start();
        try {
            mos.startWriting();
            t1.join();
            t2.join();
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        WorkspaceItemUtil.updateMimeTypeIntoStorage(storage, metadataInfo, remotePath, filenameWithExtension);
        return metadataInfo;
    }
}

