/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPrivilegesInfo {
    private static Logger logger = LoggerFactory.getLogger(JCRPrivilegesInfo.class);

    public static boolean canAddChildren(String owner, String currentUser, String absPath) throws InternalErrorException {
        if (owner.equals(currentUser)) {
            return true;
        }
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.canAddChildren(currentUser, absPath);
    }

    public static boolean canDeleteChildren(String user, String absPath) throws InternalErrorException {
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.canDeleteChildren(user, absPath);
    }

    public static boolean canDelete(String owner, String currentUser, String absPath, boolean root) throws InternalErrorException {
        if (owner.equals(currentUser)) {
            return true;
        }
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.canDelete(currentUser, absPath, root);
    }

    public static boolean canModifyProperties(String owner, String currentUser, String absPath, boolean root) throws InternalErrorException {
        if (owner.equals(currentUser)) {
            return true;
        }
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.canModifyProperties(currentUser, absPath, root);
    }

    public static ACLType getACLByUser(String user, String absPath) throws InternalErrorException {
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.getACLByUser(user, absPath);
    }

    public static boolean canReadNode(String owner, String currentUser, String absPath) throws InternalErrorException {
        if (owner.equals(currentUser)) {
            return true;
        }
        JCRAccessManager acManager = new JCRAccessManager();
        return acManager.canReadNode(currentUser, absPath);
    }
}

