/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeriesInfo;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.homelibrary.util.zip.UnzipUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRTimeSeries
extends JCRWorkspaceFolderItem
implements TimeSeries {
    public JCRTimeSeries(JCRWorkspace workspace, ItemDelegate node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRTimeSeries(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV) throws RepositoryException, InternalErrorException, RemoteBackendException {
        super(workspace, itemDelegate, name, description);
        Validate.notNull((Object)timeseriesId, (String)"TimeSeriesId must be not null");
        Validate.notNull((Object)title, (String)"Title must be not null");
        Validate.notNull((Object)creator, (String)"Creator must be not null");
        Validate.notNull((Object)timeseriesDescription, (String)"TimeseriesDescription must be not null");
        Validate.notNull((Object)timeseriesCreationDate, (String)"TimeSeriesCreationDate must be not null");
        Validate.notNull((Object)publisher, (String)"Publisher must be not null");
        Validate.notNull((Object)sourceId, (String)"SourceId must be not null");
        Validate.notNull((Object)sourceName, (String)"SourceName must be not null");
        Validate.notNull((Object)rights, (String)"Rights must be not null");
        Validate.notNull(headerLabels, (String)"HeaderLabels must be not null");
        Validate.notNull((Object)compressedCSV, (String)"CompressedCSV must be not null");
        Map properties = itemDelegate.getProperties();
        properties.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.TIME_SERIES.toString());
        File tmpFile = null;
        try {
            tmpFile = WorkspaceUtil.getTmpFile((InputStream)compressedCSV);
            new JCRFile(workspace, itemDelegate, null, tmpFile);
        }
        catch (Exception e) {
            logger.error("Error creating TimeSeries from " + itemDelegate.getPath());
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.TIMESERIES_CREATED, new XStream().toXML((Object)timeseriesCreationDate));
        content.put(NodeProperty.TIMESERIES_CREATOR, creator);
        content.put(NodeProperty.TIMESERIES_DESCRIPTION, description);
        content.put(NodeProperty.TIMESERIES_DIMENSION, new XStream().toXML((Object)dimension));
        content.put(NodeProperty.TIMESERIES_ID, timeseriesId);
        content.put(NodeProperty.TIMESERIES_PUBLISHER, publisher);
        content.put(NodeProperty.TIMESERIES_RIGHTS, rights);
        content.put(NodeProperty.TIMESERIES_SOURCE_ID, sourceId);
        content.put(NodeProperty.TIMESERIES_SOURCE_NAME, sourceName);
        content.put(NodeProperty.TIMESERIES_TITLE, title);
        content.put(NodeProperty.HEADER_LABELS, new XStream().toXML((Object)headerLabels.toArray(new String[headerLabels.size()])));
    }

    @Override
    public long getLength() throws InternalErrorException {
        long lenght = 0L;
        try {
            lenght = (Long)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.SIZE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lenght;
    }

    public int getNumberOfColumns() {
        int size = 0;
        try {
            Map labels = (Map)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.HEADER_LABELS));
            size = labels.size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    public TimeSeriesInfo getTimeSeriesInfo() {
        try {
            Map content = this.delegate.getContent();
            String timeseriesId = (String)content.get(NodeProperty.TIMESERIES_ID);
            String title = (String)content.get(NodeProperty.TIMESERIES_TITLE);
            String creator = (String)content.get(NodeProperty.TIMESERIES_CREATOR);
            String timeseriesDescription = (String)content.get(NodeProperty.TIMESERIES_DESCRIPTION);
            String timeseriesCreationDate = (String)content.get(NodeProperty.TIMESERIES_CREATED);
            String publisher = (String)content.get(NodeProperty.TIMESERIES_PUBLISHER);
            String sourceId = (String)content.get(NodeProperty.TIMESERIES_SOURCE_ID);
            String sourceName = (String)content.get(NodeProperty.TIMESERIES_SOURCE_NAME);
            String rights = (String)content.get(NodeProperty.TIMESERIES_RIGHTS);
            long dimension = (Long)new XStream().fromXML((String)content.get(NodeProperty.TIMESERIES_DIMENSION));
            TimeSeriesInfo timeSeriesInfo = new TimeSeriesInfo(timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension);
            return timeSeriesInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getHeaderLabels() {
        Map labels;
        try {
            labels = (Map)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.HEADER_LABELS));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (List)((Object)labels.keySet());
    }

    public InputStream getData() throws InternalErrorException {
        try {
            return UnzipUtil.unzipToTmp((InputStream)this.getCompressedData());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public InputStream getCompressedData() throws InternalErrorException {
        try {
            JCRFile file = new JCRFile(this.workspace, this.delegate);
            return file.getData();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.TIME_SERIES;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        String mimetype;
        try {
            mimetype = (String)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.MIME_TYPE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mimetype;
    }
}

