package org.gcube.common.homelibrary.jcr.workspace.trash;


import java.util.ArrayList;
import java.util.List;

import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;

public class JCRWorkspaceTrashFolder extends JCRWorkspaceFolder implements WorkspaceTrashFolder{


	private static final String NT_TRASH_ITEM 					= "nthl:trashItem";


	public JCRWorkspaceTrashFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
		super(workspace, delegate);
	}


	@Override
	public WorkspaceTrashItem getTrashItemById(String id)
			throws InternalErrorException {

		ItemDelegate trashNode = null;
		JCRWorkspaceTrashItem trashItem = null;
		try {

			trashNode = JCRRepository.getServlets().getItemById(id);
			if (trashNode.getPrimaryType().equals(NT_TRASH_ITEM)){
				try{
					trashItem = new JCRWorkspaceTrashItem(workspace, trashNode);

				}catch (Exception e) {
					throw new InternalErrorException("Trash not found " + e);
				}	
			}
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} 
		return trashItem;
	}


	@Override
	public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
	
		ItemDelegate node = null;
		List<WorkspaceTrashItem> children = null;
		try {

			children = new ArrayList<WorkspaceTrashItem>();

			node = JCRRepository.getServlets().getItemById(getId());

			DelegateManager wrap = new DelegateManager(node, workspace.getOwner().getPortalLogin());
			List<ItemDelegate> trashNodes = wrap.getNodes();

			for (ItemDelegate trashNode : trashNodes){

				if (trashNode.getPrimaryType().equals(NT_TRASH_ITEM)){
					WorkspaceTrashItem trashItem = (WorkspaceTrashItem) workspace.getItem(trashNode.getId());
					children.add(trashItem);
				}
			}

		} catch (Exception e) {
			throw new InternalErrorException(e);
		}
		return children;
	}


	@Override
	public List<String> emptyTrash() throws InternalErrorException {

		ItemDelegate trashNode = null;
		try {
			trashNode = JCRRepository.getServlets().getItemById(getId());

			DelegateManager wrap = new DelegateManager(trashNode, workspace.getOwner().getPortalLogin());
			List<ItemDelegate> children = wrap.getNodes();

			for (ItemDelegate child : children){

				if (child.getPrimaryType().equals(NT_TRASH_ITEM)){
					try{
						JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(workspace, child);
						trashItem.deletePermanently();
					}catch (Exception e) {
						throw new InternalErrorException(e);
					}	
				}
			}
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} 

		return null;
	}

	@Override
	public List<String> restoreAll() throws InternalErrorException {

		ItemDelegate trashNode = null;
		try {

			trashNode = JCRRepository.getServlets().getItemById(getId());
			DelegateManager wrap = new DelegateManager(trashNode, workspace.getOwner().getPortalLogin());
			List<ItemDelegate> children = wrap.getNodes();
			for (ItemDelegate child : children){

				if (child.getPrimaryType().equals(NT_TRASH_ITEM)){
					try{
						JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(workspace, child);
						trashItem.restore();
					}catch (Exception e) {
						throw new InternalErrorException(e);
					}	
				}
			}

		} catch (Exception e) {
			throw new InternalErrorException(e);
		} 

		return null;
	}

	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.TRASH_FOLDER;
	}



}
